/*
 * Decompiled with CFR 0.152.
 */
package io.sitoolkit.wt.domain.debug;

import io.sitoolkit.wt.domain.debug.CommandKey;
import io.sitoolkit.wt.domain.debug.LocatorChecker;
import io.sitoolkit.wt.domain.debug.TestScriptGenerateTool;
import io.sitoolkit.wt.domain.tester.TestContext;
import io.sitoolkit.wt.domain.testscript.Locator;
import io.sitoolkit.wt.domain.testscript.TestScript;
import io.sitoolkit.wt.infra.log.SitLogger;
import io.sitoolkit.wt.infra.log.SitLoggerFactory;
import java.awt.Desktop;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.ApplicationContext;

class DebugCommand {
    private static SitLogger LOG = SitLoggerFactory.getLogger(DebugCommand.class);
    CommandKey key;
    String body;
    static Map<String, CommandKey> map = new HashMap<String, CommandKey>();
    static final DebugCommand NA;

    public DebugCommand(CommandKey key, String body) {
        this.key = key;
        this.body = body;
    }

    static DebugCommand readLine(String line) {
        if (StringUtils.isBlank(line)) {
            return NA;
        }
        CommandKey key = map.get(line.substring(0, 1));
        if (key == null) {
            return NA;
        }
        return new DebugCommand(key, line.substring(1).trim());
    }

    int execute(int idx, TestScript testScript, ApplicationContext appCtx) {
        int ret = idx;
        switch (this.key) {
            case START: {
                ret = idx + 1;
                break;
            }
            case BACK: {
                ret = idx - 1;
                break;
            }
            case CURRENT: {
                ret = idx;
                break;
            }
            case FORWARD: {
                ret = idx + 1;
                break;
            }
            case EXEC_STEP_NO: {
                ret = testScript.getIndexByScriptNo(this.body);
                break;
            }
            case SET_STEP_NO: {
                ret = testScript.getIndexByScriptNo(this.body) - 1;
                break;
            }
            case LOC: {
                LocatorChecker check = appCtx.getBean(LocatorChecker.class);
                Locator locator = Locator.build(this.body);
                if (locator.isNa()) {
                    LOG.info("format.valid");
                    break;
                }
                check.check(locator);
                break;
            }
            case SHOW_PARAM: {
                this.showParam(appCtx);
                break;
            }
            case INPUT_PARAM: {
                this.inputParam(appCtx);
                break;
            }
            case EXPORT: {
                try {
                    TestScriptGenerateTool exporter = appCtx.getBean(TestScriptGenerateTool.class);
                    exporter.generateFromPage();
                }
                catch (Exception e) {
                    LOG.error("export.error", e);
                }
                break;
            }
            case OPEN_SRCIPT: {
                try {
                    Desktop.getDesktop().open(testScript.getScriptFile());
                }
                catch (IOException e) {
                    LOG.error("unexpected.error", e);
                }
                break;
            }
            case EXIT: {
                ret = testScript.getTestStepList().size();
                break;
            }
        }
        return ret;
    }

    protected void inputParam(ApplicationContext appCtx) {
        TestContext testCtx = appCtx.getBean(TestContext.class);
        if (StringUtils.isBlank(this.body)) {
            LOG.info("format.valid");
            return;
        }
        this.body = this.body.trim();
        String key = StringUtils.substringBefore(this.body, " ");
        String value = StringUtils.substringAfter(this.body, " ");
        testCtx.addParam(key, value);
        LOG.info("add.param", key, value);
    }

    protected void showParam(ApplicationContext appCtx) {
        TestContext testCtx = appCtx.getBean(TestContext.class);
        if (testCtx.getParams().isEmpty()) {
            LOG.info("param.empty");
            return;
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, Object> entry : testCtx.getParams().entrySet()) {
            sb.append("\n    ");
            sb.append(entry.getKey());
            sb.append("=");
            sb.append(entry.getValue());
        }
        LOG.info("show.param", sb);
    }

    static {
        for (CommandKey key : CommandKey.values()) {
            if (key.key.length() <= 0) continue;
            map.put(key.key.substring(0, 1), key);
        }
        NA = new DebugCommand(CommandKey.NA, "");
    }
}

