/*
 * Decompiled with CFR 0.152.
 */
package io.sitoolkit.wt.app.sample;

import io.sitoolkit.wt.app.sample.SampleManagerConfig;
import io.sitoolkit.wt.infra.resource.MessageManager;
import io.sitoolkit.wt.infra.template.MergedFileGenerator;
import io.sitoolkit.wt.util.infra.util.FileIOUtils;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;

public class SampleManager {
    private String projectDir = null;
    private static final String RESOURCE_DIR = "sample/";
    @Resource
    private MergedFileGenerator mergedFileGenerator;

    public static void staticUnarchiveBasicSample() {
        try (AnnotationConfigApplicationContext appCtx = new AnnotationConfigApplicationContext(SampleManagerConfig.class);){
            appCtx.getBean(SampleManager.class).unarchiveBasicSample();
        }
    }

    public void unarchiveBasicSample(String projectDir) {
        this.projectDir = projectDir;
        this.unarchiveBasicSample();
    }

    private void unarchiveBasicSample() {
        this.unarchive("bootstrap.min.css");
        Map<String, String> properties = MessageManager.getResourceAsMap();
        this.generateLocalizedHtml("input", properties);
        this.generateLocalizedHtml("terms", properties);
        this.generateLocalizedHtml("done", properties);
        this.mergedFileGenerator.generate("sample/SampleTestScript", this.getDestPath("testscript"), "SampleTestScript", "csv", properties);
    }

    private void unarchive(String filename) {
        String resource = RESOURCE_DIR + filename;
        FileIOUtils.sysRes2file(resource, this.getDestPath(resource));
    }

    private void generateLocalizedHtml(String fileBase, Map<String, String> properties) {
        this.mergedFileGenerator.generate(RESOURCE_DIR + fileBase, this.getDestPath(RESOURCE_DIR), fileBase, "html", properties);
    }

    private Path getDestPath(String path) {
        return this.projectDir == null ? Paths.get(path, new String[0]) : Paths.get(this.projectDir, path);
    }

    public static void main(String[] args) {
        SampleManager.staticUnarchiveBasicSample();
    }
}

