/*
 * Decompiled with CFR 0.152.
 */
package io.sitoolkit.wt.app.compareevidence;

import io.sitoolkit.wt.app.compareevidence.ScreenshotComparatorConfig;
import io.sitoolkit.wt.domain.evidence.EvidenceDir;
import io.sitoolkit.wt.infra.log.SitLogger;
import io.sitoolkit.wt.infra.log.SitLoggerFactory;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import javax.imageio.ImageIO;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;

public class ScreenshotComparator {
    private static final SitLogger LOG = SitLoggerFactory.getLogger(ScreenshotComparator.class);
    int openFileCount = 1;

    public static void staticExecute(EvidenceDir baseDir, EvidenceDir targetDir) {
        AnnotationConfigApplicationContext appCtx = new AnnotationConfigApplicationContext(ScreenshotComparatorConfig.class);
        ScreenshotComparator comparator = appCtx.getBean(ScreenshotComparator.class);
        for (File evidenceFile : targetDir.getEvidenceFiles()) {
            comparator.compare(baseDir, targetDir, evidenceFile);
        }
    }

    public boolean compare(EvidenceDir baseDir, EvidenceDir targetDir, File evidenceFile) {
        LOG.info("screenshot.compare", evidenceFile, baseDir.getDir(), targetDir.getDir());
        if (!baseDir.exists()) {
            LOG.info("base.dir.none", baseDir.getDir().getPath());
            return false;
        }
        Map<String, File> baseSsMap = baseDir.getScreenshotFilesAsMap(evidenceFile.getName());
        boolean match = true;
        for (Map.Entry<String, File> targetEntry : targetDir.getScreenshotFilesAsMap(evidenceFile.getName()).entrySet()) {
            if (baseSsMap.get(EvidenceDir.toMaskSsName(targetEntry.getKey())) != null) continue;
            File baseSs = baseSsMap.get(targetEntry.getKey());
            File targetSs = targetEntry.getValue();
            if (baseSs == null) {
                LOG.warn("base.screenshot.none", targetEntry.getKey());
                match = false;
                continue;
            }
            match &= this.compareOneScreenshot(baseSs, targetSs, 10, 10);
        }
        return match;
    }

    public boolean compareOneScreenshot(File baseImg, File targetImg, int rows, int columns) {
        boolean match = true;
        BufferedImage[][] baseBfImg = this.splitImage(baseImg, rows, columns);
        BufferedImage[][] targetBfImg = this.splitImage(targetImg, rows, columns);
        BufferedImage[][] diffImg = new BufferedImage[rows][columns];
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < columns; ++j) {
                byte[] targetImgBytes;
                byte[] baseImgBytes = this.toByteArray(baseBfImg[i][j]);
                if (Arrays.equals(baseImgBytes, targetImgBytes = this.toByteArray(targetBfImg[i][j]))) {
                    diffImg[i][j] = this.darken(targetBfImg[i][j]);
                    continue;
                }
                match = false;
                diffImg[i][j] = targetBfImg[i][j];
            }
        }
        if (match) {
            LOG.info("screenshot.match", targetImg.getName());
        } else {
            LOG.error("screenshot.unmatch", targetImg.getName());
            this.writeDiffImg(targetImg, diffImg);
        }
        return match;
    }

    public BufferedImage[][] splitImage(File baseImg, int rows, int columns) {
        BufferedImage[][] splitImages = new BufferedImage[rows][columns];
        try {
            BufferedImage bufferedImage = ImageIO.read(baseImg);
            for (int i = 0; i < splitImages.length; ++i) {
                for (int j = 0; j < splitImages[i].length; ++j) {
                    int posX = bufferedImage.getWidth() / columns * j;
                    int posY = bufferedImage.getHeight() / rows * i;
                    int width = j == splitImages[i].length - 1 ? bufferedImage.getWidth() - posX : bufferedImage.getWidth() / columns;
                    int height = i == splitImages.length - 1 ? bufferedImage.getHeight() - posY : bufferedImage.getHeight() / rows;
                    splitImages[i][j] = bufferedImage.getSubimage(posX, posY, width, height);
                }
            }
        }
        catch (IOException e) {
            LOG.error("split.image.error", e);
        }
        return splitImages;
    }

    private void writeDiffImg(File targetImg, BufferedImage[][] bio) {
        try {
            BufferedImage img = ImageIO.read(targetImg);
            BufferedImage imgBase = new BufferedImage(img.getWidth(), img.getHeight(), 2);
            Graphics graphics = imgBase.getGraphics();
            int posX = bio[0][0].getWidth();
            int posY = bio[0][0].getHeight();
            for (int i = 0; i < bio.length; ++i) {
                for (int j = 0; j < bio[i].length; ++j) {
                    graphics.drawImage(bio[i][j], posX * j, posY * i, null);
                }
            }
            File maskedImg = new File(targetImg.getParent(), EvidenceDir.toUnmatchSsName(targetImg.getName()));
            ImageIO.write((RenderedImage)imgBase, "png", maskedImg);
            LOG.info("write.diff.image", maskedImg);
        }
        catch (IOException e) {
            LOG.error("write.diff.image.error", e);
        }
    }

    private BufferedImage darken(BufferedImage bi) {
        Graphics2D g2d = bi.createGraphics();
        Color color = new Color(0.2f, 0.2f, 0.2f, 0.8f);
        g2d.setPaint(color);
        g2d.fillRect(0, 0, bi.getWidth(), bi.getHeight());
        return bi;
    }

    private byte[] toByteArray(BufferedImage bi) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] byteArray = new byte[]{};
        try {
            ImageIO.write((RenderedImage)bi, "png", baos);
            baos.flush();
            byteArray = baos.toByteArray();
            baos.close();
        }
        catch (IOException e) {
            LOG.error("byte.array.error", e);
        }
        return byteArray;
    }
}

