/*
 * Decompiled with CFR 0.152.
 */
package io.sitoolkit.wt.app.compareevidence;

import io.sitoolkit.wt.domain.evidence.ElementPosition;
import io.sitoolkit.wt.domain.evidence.EvidenceDir;
import io.sitoolkit.wt.domain.evidence.MaskInfo;
import io.sitoolkit.wt.infra.log.SitLogger;
import io.sitoolkit.wt.infra.log.SitLoggerFactory;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;

public class MaskScreenshotGenerator {
    private static final SitLogger LOG = SitLoggerFactory.getLogger(MaskScreenshotGenerator.class);

    public List<File> generate(EvidenceDir targetDir) {
        LOG.info("screenshot.generate", targetDir.getDir());
        ArrayList<File> maskedFiles = new ArrayList<File>();
        if (!targetDir.exists()) {
            LOG.error("evidence.error");
            return maskedFiles;
        }
        MaskInfo maskInfo = MaskInfo.load(targetDir);
        for (File evidence : targetDir.getEvidenceFiles()) {
            for (File screenshot : targetDir.getScreenshots(evidence.getName())) {
                if (maskInfo.getMaskInfoAsMap().get(screenshot.getName()) == null) continue;
                maskedFiles.add(this.mask(screenshot, maskInfo));
            }
        }
        return maskedFiles;
    }

    public File mask(File imgFile, MaskInfo maskInfo) {
        File maskedImg = new File(imgFile.getParent(), EvidenceDir.toMaskSsName(imgFile.getName()));
        try {
            BufferedImage bi = ImageIO.read(imgFile);
            Graphics2D g2d = bi.createGraphics();
            g2d.setPaint(Color.BLACK);
            List<ElementPosition> posStyles = maskInfo.getMaskInfoAsMap().get(imgFile.getName());
            for (ElementPosition elementPosition : posStyles) {
                int posX = elementPosition.getX();
                int posY = elementPosition.getY();
                int width = elementPosition.getW();
                int height = elementPosition.getH();
                g2d.fillRect(posX, posY, width, height);
                ImageIO.write((RenderedImage)bi, "png", maskedImg);
            }
            LOG.info("mask.generate", maskedImg.getPath());
        }
        catch (IOException e) {
            LOG.error("mask.error", e);
        }
        return maskedImg;
    }
}

