/*
 * Decompiled with CFR 0.152.
 */
package io.sitoolkit.util.buildtoolhelper.proxysetting;

import io.sitoolkit.util.buildtoolhelper.process.StdoutListener;
import io.sitoolkit.util.buildtoolhelper.proxysetting.ProxyProtocol;
import io.sitoolkit.util.buildtoolhelper.proxysetting.ProxySetting;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class ProxySettingStdoutListener
implements StdoutListener {
    private boolean isProxyEnabled = false;
    private boolean isParsed = false;
    private ProxySetting baseSetting = new ProxySetting();
    private List<ProxySetting> proxySettings = new ArrayList<ProxySetting>();

    @Override
    public void nextLine(String line) {
        if (line.trim().startsWith("Proxy")) {
            this.parse(line.trim());
        }
    }

    public void parseProxyHost() {
        String proxyURLs = this.baseSetting.getProxyHost();
        if (!this.isProxyEnabled || StringUtils.isEmpty(proxyURLs)) {
            return;
        }
        if (proxyURLs.contains(";")) {
            for (String protocolDetail : proxyURLs.split(";")) {
                String[] protocolDetails = protocolDetail.split("=");
                String protocol2 = protocolDetails[0];
                if (!ProxyProtocol.contains(protocol2)) continue;
                String proxyURL = protocolDetails[1];
                ProxyURL url = this.parseProxyURL(proxyURL);
                this.proxySettings.add(this.createProxySettingFromBase(ProxyProtocol.getValue(protocol2), url));
            }
        } else {
            ProxyURL url = this.parseProxyURL(proxyURLs);
            this.proxySettings = ProxyProtocol.getValueList().stream().map(protocol -> this.createProxySettingFromBase((ProxyProtocol)((Object)protocol), url)).collect(Collectors.toList());
        }
        this.isParsed = true;
    }

    public List<ProxySetting> getProxySettings() {
        if (!this.isParsed) {
            this.parseProxyHost();
        }
        return this.proxySettings;
    }

    private void parse(String line) {
        String[] details = line.split(" +");
        switch (details[0]) {
            case "ProxyEnable": {
                if (!"0x1".equals(details[2])) break;
                this.isProxyEnabled = true;
                break;
            }
            case "ProxyServer": {
                this.baseSetting.setProxyHost(details[2]);
                break;
            }
            case "ProxyOverride": {
                this.baseSetting.setNonProxyHosts(details[2].replaceAll(";", "|"));
            }
        }
    }

    private ProxySetting createProxySettingFromBase(ProxyProtocol protocol, ProxyURL url) {
        return new ProxySetting(protocol, url.getHost(), url.getPort(), this.baseSetting.getProxyUser(), this.baseSetting.getProxyPassword(), this.baseSetting.getNonProxyHosts());
    }

    private ProxyURL parseProxyURL(String proxyURL) {
        String[] settings = proxyURL.split(":");
        String host = settings[0];
        String port = settings.length == 2 ? settings[1] : "80";
        return new ProxyURL(host, port);
    }

    private final class ProxyURL {
        private final String host;
        private final String port;

        public String getHost() {
            return this.host;
        }

        public String getPort() {
            return this.port;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ProxyURL)) {
                return false;
            }
            ProxyURL other = (ProxyURL)o;
            String this$host = this.getHost();
            String other$host = other.getHost();
            if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
                return false;
            }
            String this$port = this.getPort();
            String other$port = other.getPort();
            return !(this$port == null ? other$port != null : !this$port.equals(other$port));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $host = this.getHost();
            result = result * 59 + ($host == null ? 43 : $host.hashCode());
            String $port = this.getPort();
            result = result * 59 + ($port == null ? 43 : $port.hashCode());
            return result;
        }

        public String toString() {
            return "ProxySettingStdoutListener.ProxyURL(host=" + this.getHost() + ", port=" + this.getPort() + ")";
        }

        public ProxyURL(String host, String port) {
            this.host = host;
            this.port = port;
        }
    }
}

