/*
 * Decompiled with CFR 0.152.
 */
package io.sitoolkit.util.buildtoolhelper.process;

import io.sitoolkit.util.buildtoolhelper.process.ProcessConversation;
import io.sitoolkit.util.buildtoolhelper.process.ProcessExecutor;
import io.sitoolkit.util.buildtoolhelper.process.ProcessExitCallback;
import io.sitoolkit.util.buildtoolhelper.process.StdoutListener;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ProcessCommand {
    private static Path defaultCurrentDirectory = Paths.get(".", new String[0]);
    private static ProcessExecutor processExecutor = new ProcessExecutor();
    private Path currentDirectory;
    private Map<String, String> env = new HashMap<String, String>();
    private String command;
    private List<String> args = new ArrayList<String>();
    private List<StdoutListener> stdoutListeners = new ArrayList<StdoutListener>();
    private List<StdoutListener> stderrListeners = new ArrayList<StdoutListener>();
    private List<ProcessExitCallback> exitCallbacks = new ArrayList<ProcessExitCallback>();

    public static void setDefaultCurrentDirectory(Path defaultCurrentDirectory) {
        ProcessCommand.defaultCurrentDirectory = defaultCurrentDirectory;
    }

    public ProcessCommand currentDirectory(Path currentDirectory) {
        this.currentDirectory = currentDirectory;
        return this;
    }

    public ProcessCommand command(String command) {
        this.command = command;
        return this;
    }

    public ProcessCommand stdout(StdoutListener stdoutListener) {
        this.stdoutListeners.add(stdoutListener);
        return this;
    }

    public ProcessCommand stderr(StdoutListener stderrListener) {
        this.stderrListeners.add(stderrListener);
        return this;
    }

    public ProcessCommand exitCallback(ProcessExitCallback exitCallback) {
        this.exitCallbacks.add(exitCallback);
        return this;
    }

    public ProcessCommand args(String ... args) {
        this.args = Arrays.asList(args);
        return this;
    }

    public ProcessCommand args(List<String> args) {
        this.args = args;
        return this;
    }

    public Path getCurrentDirectory() {
        return this.currentDirectory == null ? defaultCurrentDirectory : this.currentDirectory;
    }

    public void execute() {
        processExecutor.execute(this);
    }

    public ProcessConversation executeAsync() {
        return processExecutor.executeAsync(this);
    }

    public List<String> getWholeCommand() {
        ArrayList<String> wholeCommand = new ArrayList<String>();
        wholeCommand.add(this.getCommand());
        wholeCommand.addAll(this.getArgs());
        return wholeCommand;
    }

    public Map<String, String> getEnv() {
        return this.env;
    }

    public String getCommand() {
        return this.command;
    }

    public List<String> getArgs() {
        return this.args;
    }

    public List<StdoutListener> getStdoutListeners() {
        return this.stdoutListeners;
    }

    public List<StdoutListener> getStderrListeners() {
        return this.stderrListeners;
    }

    public List<ProcessExitCallback> getExitCallbacks() {
        return this.exitCallbacks;
    }

    public void setCurrentDirectory(Path currentDirectory) {
        this.currentDirectory = currentDirectory;
    }

    public void setEnv(Map<String, String> env) {
        this.env = env;
    }

    public void setCommand(String command) {
        this.command = command;
    }

    public void setArgs(List<String> args) {
        this.args = args;
    }

    public void setStdoutListeners(List<StdoutListener> stdoutListeners) {
        this.stdoutListeners = stdoutListeners;
    }

    public void setStderrListeners(List<StdoutListener> stderrListeners) {
        this.stderrListeners = stderrListeners;
    }

    public void setExitCallbacks(List<ProcessExitCallback> exitCallbacks) {
        this.exitCallbacks = exitCallbacks;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProcessCommand)) {
            return false;
        }
        ProcessCommand other = (ProcessCommand)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Path this$currentDirectory = this.getCurrentDirectory();
        Path other$currentDirectory = other.getCurrentDirectory();
        if (this$currentDirectory == null ? other$currentDirectory != null : !((Object)this$currentDirectory).equals(other$currentDirectory)) {
            return false;
        }
        Map<String, String> this$env = this.getEnv();
        Map<String, String> other$env = other.getEnv();
        if (this$env == null ? other$env != null : !((Object)this$env).equals(other$env)) {
            return false;
        }
        String this$command = this.getCommand();
        String other$command = other.getCommand();
        if (this$command == null ? other$command != null : !this$command.equals(other$command)) {
            return false;
        }
        List<String> this$args = this.getArgs();
        List<String> other$args = other.getArgs();
        if (this$args == null ? other$args != null : !((Object)this$args).equals(other$args)) {
            return false;
        }
        List<StdoutListener> this$stdoutListeners = this.getStdoutListeners();
        List<StdoutListener> other$stdoutListeners = other.getStdoutListeners();
        if (this$stdoutListeners == null ? other$stdoutListeners != null : !((Object)this$stdoutListeners).equals(other$stdoutListeners)) {
            return false;
        }
        List<StdoutListener> this$stderrListeners = this.getStderrListeners();
        List<StdoutListener> other$stderrListeners = other.getStderrListeners();
        if (this$stderrListeners == null ? other$stderrListeners != null : !((Object)this$stderrListeners).equals(other$stderrListeners)) {
            return false;
        }
        List<ProcessExitCallback> this$exitCallbacks = this.getExitCallbacks();
        List<ProcessExitCallback> other$exitCallbacks = other.getExitCallbacks();
        return !(this$exitCallbacks == null ? other$exitCallbacks != null : !((Object)this$exitCallbacks).equals(other$exitCallbacks));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ProcessCommand;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Path $currentDirectory = this.getCurrentDirectory();
        result = result * 59 + ($currentDirectory == null ? 43 : ((Object)$currentDirectory).hashCode());
        Map<String, String> $env = this.getEnv();
        result = result * 59 + ($env == null ? 43 : ((Object)$env).hashCode());
        String $command = this.getCommand();
        result = result * 59 + ($command == null ? 43 : $command.hashCode());
        List<String> $args = this.getArgs();
        result = result * 59 + ($args == null ? 43 : ((Object)$args).hashCode());
        List<StdoutListener> $stdoutListeners = this.getStdoutListeners();
        result = result * 59 + ($stdoutListeners == null ? 43 : ((Object)$stdoutListeners).hashCode());
        List<StdoutListener> $stderrListeners = this.getStderrListeners();
        result = result * 59 + ($stderrListeners == null ? 43 : ((Object)$stderrListeners).hashCode());
        List<ProcessExitCallback> $exitCallbacks = this.getExitCallbacks();
        result = result * 59 + ($exitCallbacks == null ? 43 : ((Object)$exitCallbacks).hashCode());
        return result;
    }

    public String toString() {
        return "ProcessCommand(currentDirectory=" + this.getCurrentDirectory() + ", env=" + this.getEnv() + ", command=" + this.getCommand() + ", args=" + this.getArgs() + ", stdoutListeners=" + this.getStdoutListeners() + ", stderrListeners=" + this.getStderrListeners() + ", exitCallbacks=" + this.getExitCallbacks() + ")";
    }
}

