/*
 * Decompiled with CFR 0.152.
 */
package io.sitoolkit.util.buildtoolhelper.maven;

import io.sitoolkit.util.buildtoolhelper.UnExpectedException;
import io.tesla.proviso.archive.UnArchiver;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.maven.wrapper.DefaultDownloader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MavenWrapperDownloader {
    private static final Logger log = LoggerFactory.getLogger(MavenWrapperDownloader.class);
    private static String version = "0.3.0";
    private static String maven = "3.5.4";
    private static String distributionUrl;

    public static void main(String[] args) {
        MavenWrapperDownloader.download(Paths.get(".", new String[0]));
    }

    public static void download(Path rootDirectory) {
        File localRepository = new File(System.getProperty("user.home"), ".m2/repository");
        String artifactPath = String.format("io/takari/maven-wrapper/%s/maven-wrapper-%s.tar.gz", version, version);
        String wrapperUrl = String.format("https://repo1.maven.org/maven2/%s", artifactPath);
        File destination = new File(localRepository, artifactPath);
        DefaultDownloader downloader = new DefaultDownloader("mvnw", version);
        try {
            downloader.download(new URI(wrapperUrl), destination);
            UnArchiver unarchiver = UnArchiver.builder().useRoot(false).build();
            unarchiver.unarchive(destination, rootDirectory.toFile());
            MavenWrapperDownloader.overwriteDistributionUrl(rootDirectory, MavenWrapperDownloader.getDistributionUrl());
            log.info("");
            log.info("The Maven Wrapper version " + version + " has been successfully setup for your project.");
            log.info("Using Apache Maven " + maven);
            log.info("");
        }
        catch (Exception e) {
            throw new UnExpectedException(e);
        }
    }

    private static void overwriteDistributionUrl(Path rootDirectory, String distributionUrl) throws IOException {
        Path wrapperProperties;
        if (!MavenWrapperDownloader.isNullOrEmpty(distributionUrl) && Files.isWritable(wrapperProperties = rootDirectory.resolve(Paths.get(".mvn", "wrapper", "maven-wrapper.properties")))) {
            String distroKeyValue = "distributionUrl=" + distributionUrl;
            Files.write(wrapperProperties, distroKeyValue.getBytes(Charset.forName("UTF-8")), new OpenOption[0]);
        }
    }

    private static String getDistributionUrl() {
        if (MavenWrapperDownloader.isNullOrEmpty(distributionUrl) && !MavenWrapperDownloader.isNullOrEmpty(maven)) {
            distributionUrl = String.format("https://repo1.maven.org/maven2/org/apache/maven/apache-maven/%s/apache-maven-%s-bin.zip", maven, maven);
        }
        return distributionUrl;
    }

    private static boolean isNullOrEmpty(String value) {
        return value == null || value.isEmpty();
    }
}

