/*
 * Decompiled with CFR 0.152.
 */
package io.sitoolkit.util.buildtoolhelper.maven;

import io.sitoolkit.util.buildtoolhelper.maven.MavenWrapperDownloader;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class MavenUtils {
    private static final Logger log = LoggerFactory.getLogger(MavenUtils.class);
    private static String mvnCommand = "";

    public static String getCommand() {
        while (mvnCommand == null || mvnCommand.isEmpty()) {
            log.info("wait for installing Maven...");
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException e) {
                log.warn(e.getLocalizedMessage(), e);
            }
        }
        return mvnCommand;
    }

    public static synchronized void findAndInstall() {
        MavenUtils.findAndInstall(Paths.get(".", new String[0]));
    }

    public static synchronized void findAndInstall(Path baseDir) {
        if (StringUtils.isEmpty(mvnCommand) && StringUtils.isEmpty(mvnCommand = MavenUtils.find(baseDir))) {
            MavenWrapperDownloader.download(baseDir);
            mvnCommand = MavenUtils.find(baseDir);
        }
        log.info("mvn command is '" + mvnCommand + "'");
    }

    public static String find(Path baseDir) {
        Path mvnw;
        Path path = mvnw = SystemUtils.IS_OS_WINDOWS ? baseDir.resolve("mvnw.cmd") : baseDir.resolve("mvnw");
        if (mvnw.toFile().exists()) {
            return mvnw.toAbsolutePath().toString();
        }
        return "";
    }

    public static File getLocalRepository() {
        File mavenUserHomeDir = new File(System.getProperty("user.home"), ".m2");
        File settingsXml = new File(mavenUserHomeDir, "settings.xml");
        File defaultLocalRepository = new File(mavenUserHomeDir, "repository");
        if (!settingsXml.exists()) {
            return defaultLocalRepository;
        }
        try {
            Document document = MavenUtils.parseSettingFile(settingsXml);
            String localRepository = XPathFactory.newInstance().newXPath().compile("/settings/localRepository").evaluate(document);
            if (StringUtils.isEmpty(localRepository)) {
                return defaultLocalRepository;
            }
            return new File(localRepository);
        }
        catch (Exception e) {
            log.warn("fail to get maven local repository path ", e);
            return defaultLocalRepository;
        }
    }

    public static Path getUserSettingFilePath() {
        Path mavenUserHomeDir = Paths.get(System.getProperty("user.home"), ".m2");
        return mavenUserHomeDir.resolve("settings.xml");
    }

    public static Document parseSettingFile(File settingFile) throws Exception {
        DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        return builder.parse(settingFile);
    }
}

