/*
 * Decompiled with CFR 0.152.
 */
package io.sitoolkit.util.buildtoolhelper.config;

import io.sitoolkit.util.buildtoolhelper.util.PropertiesUtil;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SitoolkitConfig {
    private static final Logger log = LoggerFactory.getLogger(SitoolkitConfig.class);
    private static final String CONFIG_DIR = System.getProperty("user.home") + File.separator + ".sitoolkit";
    private static final String CONFIG_NAME = "config.properties";
    private static SitoolkitConfig instance;
    private Properties properties;

    private SitoolkitConfig() {
    }

    public static SitoolkitConfig getInstance() {
        if (instance == null) {
            instance = new SitoolkitConfig();
            instance.loadProperties();
        }
        return instance;
    }

    private void loadProperties() {
        Path configFile = this.getConfigFilePath();
        if (!configFile.toFile().exists()) {
            log.info("{} was not found", (Object)configFile);
            return;
        }
        log.info("Read config: {}", (Object)configFile);
        try {
            this.properties = PropertiesUtil.loadFile(configFile);
        }
        catch (Exception e) {
            log.warn("Failed to read {}", (Object)configFile, (Object)e);
            return;
        }
    }

    public Path getConfigFilePath() {
        return Paths.get(CONFIG_DIR, CONFIG_NAME);
    }

    public String getProperty(String key) {
        if (this.properties == null) {
            return "";
        }
        return this.properties.getProperty(key);
    }
}

