/*
 * Decompiled with CFR 0.152.
 */
package io.github.bonigarcia.wdm.managers;

import io.github.bonigarcia.wdm.WebDriverManager;
import io.github.bonigarcia.wdm.config.DriverManagerType;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.SystemUtils;

public class EdgeDriverManager
extends WebDriverManager {
    protected static final String LATEST_STABLE = "LATEST_STABLE";

    @Override
    public DriverManagerType getDriverManagerType() {
        return DriverManagerType.EDGE;
    }

    @Override
    protected String getDriverName() {
        return "msedgedriver";
    }

    @Override
    protected String getShortDriverName() {
        return "edgedriver";
    }

    @Override
    protected String getDriverVersion() {
        return this.config().getEdgeDriverVersion();
    }

    @Override
    protected String getBrowserVersion() {
        return this.config().getEdgeVersion();
    }

    @Override
    protected void setDriverVersion(String driverVersion) {
        this.config().setEdgeDriverVersion(driverVersion);
    }

    @Override
    protected void setBrowserVersion(String browserVersion) {
        this.config().setEdgeVersion(browserVersion);
    }

    @Override
    protected URL getDriverUrl() {
        return this.config().getEdgeDriverUrl();
    }

    @Override
    protected Optional<URL> getMirrorUrl() {
        return Optional.empty();
    }

    @Override
    protected Optional<String> getExportParameter() {
        return Optional.of(this.config().getEdgeDriverExport());
    }

    @Override
    protected void setDriverUrl(URL url) {
        this.config().setEdgeDriverUrl(url);
    }

    @Override
    protected List<URL> getDriverUrls() throws IOException {
        return this.getDriversFromXml(new URL(this.getDriverUrl() + "?restype=container&comp=list"), "//Blob/Name");
    }

    @Override
    protected String preDownload(String target, String driverVersion) {
        int iVersion = target.indexOf(driverVersion);
        if (iVersion != -1) {
            target = target.substring(0, iVersion) + this.config().getArchitecture().name().toLowerCase() + File.separator + target.substring(iVersion);
        }
        log.trace("Pre-download in EdgeDriver -- target={}, driverVersion={}", (Object)target, (Object)driverVersion);
        return target;
    }

    @Override
    protected File postDownload(File archive) {
        Collection<File> listFiles = FileUtils.listFiles(new File(archive.getParent()), null, true);
        Iterator<File> iterator = listFiles.iterator();
        File file = null;
        while (iterator.hasNext()) {
            file = iterator.next();
            if (!file.getName().contains(this.getDriverName())) continue;
            return file;
        }
        return file;
    }

    @Override
    protected Optional<String> getBrowserVersionFromTheShell() {
        String[] programFilesEnvs = new String[]{this.getProgramFilesEnv()};
        String[] winBrowserNames = new String[]{"\\\\Microsoft\\\\Edge\\\\Application\\\\msedge.exe", "\\\\Microsoft\\\\Edge Beta\\\\Application\\\\msedge.exe", "\\\\Microsoft\\\\Edge Dev\\\\Application\\\\msedge.exe"};
        String macBrowserName = "/Applications/Microsoft Edge.app/Contents/MacOS/Microsoft Edge";
        String versionFlag = SystemUtils.IS_OS_MAC_OSX ? "-version" : "--version";
        return this.versionDetector.getDefaultBrowserVersion(programFilesEnvs, winBrowserNames, "", macBrowserName, versionFlag, this.getDriverManagerType().toString());
    }

    @Override
    protected Optional<String> getLatestDriverVersionFromRepository() {
        if (this.config().isUseBetaVersions()) {
            return Optional.empty();
        }
        return this.getDriverVersionFromRepository(Optional.empty());
    }

    @Override
    protected Charset getVersionCharset() {
        return StandardCharsets.UTF_16;
    }

    @Override
    protected String getLatestVersionLabel() {
        return LATEST_STABLE;
    }
}

