/*
 * Decompiled with CFR 0.152.
 */
package com.opencsv.bean.concurrent;

import com.opencsv.bean.MappingStrategy;
import com.opencsv.bean.OpencsvUtils;
import com.opencsv.bean.concurrent.OrderedObject;
import com.opencsv.exceptions.CsvException;
import com.opencsv.exceptions.CsvRuntimeException;
import java.util.concurrent.BlockingQueue;

public class ProcessCsvBean<T>
implements Runnable {
    private final long lineNumber;
    private final MappingStrategy<T> mappingStrategy;
    private final T bean;
    private final BlockingQueue<OrderedObject<String[]>> resultantLineQueue;
    private final BlockingQueue<OrderedObject<CsvException>> thrownExceptionsQueue;
    private final boolean throwExceptions;

    public ProcessCsvBean(long lineNumber, MappingStrategy<T> mappingStrategy, T bean2, BlockingQueue<OrderedObject<String[]>> resultantLineQueue, BlockingQueue<OrderedObject<CsvException>> thrownExceptionsQueue, boolean throwExceptions) {
        this.lineNumber = lineNumber;
        this.mappingStrategy = mappingStrategy;
        this.bean = bean2;
        this.resultantLineQueue = resultantLineQueue;
        this.thrownExceptionsQueue = thrownExceptionsQueue;
        this.throwExceptions = throwExceptions;
    }

    @Override
    public void run() {
        try {
            OpencsvUtils.queueRefuseToAcceptDefeat(this.resultantLineQueue, new OrderedObject<String[]>(this.lineNumber, this.mappingStrategy.transmuteBean(this.bean)));
        }
        catch (CsvException e) {
            e.setLineNumber(this.lineNumber);
            if (this.throwExceptions) {
                throw new RuntimeException(e);
            }
            OpencsvUtils.queueRefuseToAcceptDefeat(this.thrownExceptionsQueue, new OrderedObject<CsvException>(this.lineNumber, e));
        }
        catch (CsvRuntimeException csvre) {
            throw csvre;
        }
        catch (Exception t) {
            throw new RuntimeException(t);
        }
    }
}

