/*
 * Decompiled with CFR 0.152.
 */
package com.opencsv.bean;

import com.opencsv.CSVReader;
import com.opencsv.bean.CsvToBeanFilter;
import com.opencsv.bean.MappingStrategy;
import com.opencsv.exceptions.CsvRequiredFieldEmptyException;
import java.beans.IntrospectionException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.ResourceBundle;
import org.apache.commons.lang3.ObjectUtils;

@Deprecated
public class IterableCSVToBean<T>
implements Iterable<T> {
    private final MappingStrategy<T> strategy;
    private final CSVReader csvReader;
    private final CsvToBeanFilter filter;
    private boolean hasHeader;
    private Locale errorLocale = Locale.getDefault();

    public IterableCSVToBean(CSVReader csvReader, MappingStrategy<T> strategy, CsvToBeanFilter filter) {
        this.csvReader = csvReader;
        this.strategy = strategy;
        this.filter = filter;
        this.hasHeader = false;
    }

    protected MappingStrategy<T> getStrategy() {
        return this.strategy;
    }

    protected CSVReader getCSVReader() {
        return this.csvReader;
    }

    protected CsvToBeanFilter getFilter() {
        return this.filter;
    }

    public T nextLine() throws IllegalAccessException, InstantiationException, IOException, IntrospectionException, InvocationTargetException, CsvRequiredFieldEmptyException {
        String[] line;
        if (!this.hasHeader) {
            this.strategy.captureHeader(this.csvReader);
            this.hasHeader = true;
        }
        T bean2 = null;
        while ((line = this.csvReader.readNext()) != null && this.filter != null && !this.filter.allowLine(line)) {
        }
        if (line != null) {
            bean2 = this.strategy.populateNewBeanWithIntrospection(line);
        }
        return bean2;
    }

    public void setErrorLocale(Locale errorLocale) {
        this.errorLocale = ObjectUtils.defaultIfNull(errorLocale, Locale.getDefault());
    }

    @Override
    public Iterator<T> iterator() {
        return this.iterator(this);
    }

    private Iterator<T> iterator(final IterableCSVToBean<T> bean2) {
        return new Iterator<T>(){
            private T nextBean;

            @Override
            public boolean hasNext() {
                if (this.nextBean != null) {
                    return true;
                }
                try {
                    this.nextBean = bean2.nextLine();
                }
                catch (CsvRequiredFieldEmptyException | IntrospectionException | IOException | IllegalAccessException | InstantiationException | InvocationTargetException e) {
                    e.printStackTrace();
                }
                return this.nextBean != null;
            }

            @Override
            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Object holder = this.nextBean;
                this.nextBean = null;
                return holder;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException(ResourceBundle.getBundle("opencsv", IterableCSVToBean.this.errorLocale).getString("read.only.iterator"));
            }
        };
    }
}

