/*
 * Decompiled with CFR 0.152.
 */
package com.opencsv.bean;

import com.opencsv.bean.AbstractFieldMap;
import com.opencsv.bean.BeanField;
import com.opencsv.bean.ComplexFieldMapEntry;
import com.opencsv.bean.FieldMapByNameEntry;
import com.opencsv.bean.RegexToBeanField;
import com.opencsv.exceptions.CsvRequiredFieldEmptyException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.commons.collections4.MultiValuedMap;
import org.apache.commons.lang3.StringUtils;

public class FieldMapByName<T>
extends AbstractFieldMap<String, String, RegexToBeanField<T>, T> {
    public FieldMapByName(Locale errorLocale) {
        super(errorLocale);
    }

    @Override
    public void putComplex(String key, BeanField<T> value) {
        this.complexMapList.add(new RegexToBeanField<T>(key, value, this.errorLocale));
    }

    public List<FieldMapByNameEntry<T>> determineMissingRequiredHeaders(String[] headersPresent) {
        LinkedList requiredStringList = new LinkedList();
        for (Map.Entry entry : this.simpleMap.entrySet()) {
            if (!((BeanField)entry.getValue()).isRequired()) continue;
            requiredStringList.add(entry.getKey());
        }
        LinkedList<ComplexFieldMapEntry> requiredRegexList = new LinkedList<ComplexFieldMapEntry>();
        for (ComplexFieldMapEntry r : this.complexMapList) {
            if (!r.getBeanField().isRequired()) continue;
            requiredRegexList.add(r);
        }
        for (String h2 : headersPresent) {
            if (requiredStringList.remove(h2.toUpperCase())) continue;
            ListIterator requiredRegexListIterator = requiredRegexList.listIterator();
            boolean found = false;
            while (!found && requiredRegexListIterator.hasNext()) {
                ComplexFieldMapEntry r = (ComplexFieldMapEntry)requiredRegexListIterator.next();
                if (!r.contains(h2)) continue;
                found = true;
                requiredRegexListIterator.remove();
            }
        }
        LinkedList<FieldMapByNameEntry<T>> missingRequiredHeaders = new LinkedList<FieldMapByNameEntry<T>>();
        for (String s2 : requiredStringList) {
            missingRequiredHeaders.add(new FieldMapByNameEntry(s2, (BeanField)this.simpleMap.get(s2), false));
        }
        for (ComplexFieldMapEntry r : requiredRegexList) {
            missingRequiredHeaders.add(new FieldMapByNameEntry(((String)r.getInitializer()).toString(), r.getBeanField(), true));
        }
        return missingRequiredHeaders;
    }

    @Override
    public String[] generateHeader(T bean2) throws CsvRequiredFieldEmptyException {
        LinkedList<Field> missingRequiredHeaders = new LinkedList<Field>();
        ArrayList headerList = new ArrayList(this.simpleMap.keySet());
        for (ComplexFieldMapEntry r : this.complexMapList) {
            MultiValuedMap m3 = (MultiValuedMap)r.getBeanField().getFieldValue(bean2);
            if (m3 != null && !m3.isEmpty()) {
                for (Map.Entry entry : m3.entries()) {
                    String key = (String)entry.getKey();
                    if (!r.contains(key)) continue;
                    headerList.add(key);
                }
                continue;
            }
            if (!r.getBeanField().isRequired()) continue;
            missingRequiredHeaders.add(r.getBeanField().getField());
        }
        if (!missingRequiredHeaders.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (Field f : missingRequiredHeaders) {
                sb.append(f.getName());
                sb.append(' ');
            }
            String errorMessage = String.format(ResourceBundle.getBundle("opencsv", this.errorLocale).getString("header.required.field.absent"), sb.toString(), StringUtils.join(headerList, ' '));
            throw new CsvRequiredFieldEmptyException(bean2.getClass(), missingRequiredHeaders, errorMessage);
        }
        Collections.sort(headerList);
        return headerList.toArray(new String[headerList.size()]);
    }
}

