/*
 * Decompiled with CFR 0.152.
 */
package com.opencsv.bean;

import com.opencsv.bean.AbstractBeanField;
import com.opencsv.bean.CsvConverter;
import com.opencsv.exceptions.CsvBadConverterException;
import com.opencsv.exceptions.CsvBeanIntrospectionException;
import com.opencsv.exceptions.CsvConstraintViolationException;
import com.opencsv.exceptions.CsvDataTypeMismatchException;
import java.lang.reflect.Field;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.NavigableSet;
import java.util.Queue;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.collections4.Bag;
import org.apache.commons.collections4.SortedBag;
import org.apache.commons.collections4.bag.HashBag;
import org.apache.commons.collections4.bag.TreeBag;
import org.apache.commons.lang3.StringUtils;

public class BeanFieldSplit<T>
extends AbstractBeanField<T> {
    private Pattern splitOn;
    private final String writeDelimiter;
    private final Class<? extends Collection> collectionType;

    public BeanFieldSplit(Field field, boolean required, Locale errorLocale, CsvConverter converter, String splitOn, String writeDelimiter, Class<? extends Collection> collectionType) {
        super(field, required, errorLocale, converter);
        this.writeDelimiter = writeDelimiter;
        if (!Collection.class.isAssignableFrom(field.getType())) {
            throw new CsvBadConverterException(BeanFieldSplit.class, String.format(ResourceBundle.getBundle("opencsv", errorLocale).getString("invalid.collection.type"), field.getType().toString()));
        }
        try {
            this.splitOn = Pattern.compile(splitOn);
        }
        catch (PatternSyntaxException e) {
            this.splitOn = Pattern.compile("");
            CsvBadConverterException csve = new CsvBadConverterException(BeanFieldSplit.class, String.format(ResourceBundle.getBundle("opencsv", errorLocale).getString("invalid.regex"), splitOn));
            csve.initCause(e);
            throw csve;
        }
        Class<?> fieldType = field.getType();
        if (!fieldType.isInterface()) {
            this.collectionType = field.getType();
        } else if (!collectionType.isInterface()) {
            this.collectionType = collectionType;
        } else if (Collection.class.equals(fieldType) || List.class.equals(fieldType)) {
            this.collectionType = ArrayList.class;
        } else if (Set.class.equals(fieldType)) {
            this.collectionType = HashSet.class;
        } else if (SortedSet.class.equals(fieldType) || NavigableSet.class.equals(fieldType)) {
            this.collectionType = TreeSet.class;
        } else if (Queue.class.equals(fieldType) || Deque.class.equals(fieldType)) {
            this.collectionType = ArrayDeque.class;
        } else if (Bag.class.equals(fieldType)) {
            this.collectionType = HashBag.class;
        } else if (SortedBag.class.equals(fieldType)) {
            this.collectionType = TreeBag.class;
        } else {
            this.collectionType = null;
            throw new CsvBadConverterException(BeanFieldSplit.class, String.format(ResourceBundle.getBundle("opencsv", errorLocale).getString("invalid.collection.type"), collectionType.toString()));
        }
        if (!field.getType().isAssignableFrom(this.collectionType)) {
            throw new CsvBadConverterException(BeanFieldSplit.class, String.format(ResourceBundle.getBundle("opencsv", errorLocale).getString("unassignable.collection.type"), collectionType.getName(), field.getType().getName()));
        }
    }

    @Override
    protected Object convert(String value) throws CsvDataTypeMismatchException, CsvConstraintViolationException {
        String[] splitValues;
        Collection collection;
        try {
            collection = this.collectionType.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            CsvBeanIntrospectionException csve = new CsvBeanIntrospectionException(String.format(ResourceBundle.getBundle("opencsv", this.errorLocale).getString("collection.cannot.be.instantiated"), this.collectionType.getCanonicalName()));
            csve.initCause(e);
            throw csve;
        }
        for (String s2 : splitValues = this.splitOn.split(value)) {
            collection.add(this.converter.convertToRead(s2));
        }
        return collection;
    }

    @Override
    protected String convertToWrite(Object value) throws CsvDataTypeMismatchException {
        String retval = "";
        if (value != null) {
            Collection collection = (Collection)value;
            Object[] convertedValue = new String[collection.size()];
            int i = 0;
            for (Object o : collection) {
                convertedValue[i++] = this.converter.convertToWrite(o);
            }
            retval = StringUtils.join(convertedValue, this.writeDelimiter);
        }
        return retval;
    }

    @Override
    protected boolean isFieldEmptyForWrite(Object value) {
        return super.isFieldEmptyForWrite(value) || ((Collection)value).isEmpty();
    }
}

