/*
 * Decompiled with CFR 0.152.
 */
package com.opencsv.bean;

import com.opencsv.bean.BeanField;
import com.opencsv.bean.CsvConverter;
import com.opencsv.exceptions.CsvBeanIntrospectionException;
import com.opencsv.exceptions.CsvConstraintViolationException;
import com.opencsv.exceptions.CsvDataTypeMismatchException;
import com.opencsv.exceptions.CsvRequiredFieldEmptyException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Locale;
import java.util.Objects;
import java.util.ResourceBundle;
import org.apache.commons.beanutils.PropertyUtilsBean;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.FieldUtils;

public abstract class AbstractBeanField<T>
implements BeanField<T> {
    protected Field field;
    private PropertyUtilsBean propUtils;
    protected boolean required;
    protected Locale errorLocale;
    protected CsvConverter converter;

    public AbstractBeanField() {
        this.required = false;
        this.errorLocale = Locale.getDefault();
    }

    @Deprecated
    public AbstractBeanField(Field field) {
        this(field, false, Locale.getDefault(), null);
    }

    @Deprecated
    public AbstractBeanField(Field field, boolean required) {
        this(field, required, Locale.getDefault(), null);
    }

    @Deprecated
    public AbstractBeanField(Field field, boolean required, Locale errorLocale) {
        this(field, required, errorLocale, null);
    }

    public AbstractBeanField(Field field, boolean required, Locale errorLocale, CsvConverter converter) {
        this.field = field;
        this.required = required;
        this.errorLocale = ObjectUtils.defaultIfNull(errorLocale, Locale.getDefault());
        this.converter = converter;
    }

    @Override
    public void setField(Field field) {
        this.field = field;
    }

    @Override
    public Field getField() {
        return this.field;
    }

    @Override
    public boolean isRequired() {
        return this.required;
    }

    @Override
    public void setRequired(boolean required) {
        this.required = required;
    }

    @Override
    public void setErrorLocale(Locale errorLocale) {
        this.errorLocale = ObjectUtils.defaultIfNull(errorLocale, Locale.getDefault());
        if (this.converter != null) {
            this.converter.setErrorLocale(this.errorLocale);
        }
    }

    @Override
    public final void setFieldValue(T bean2, String value, String header) throws CsvDataTypeMismatchException, CsvRequiredFieldEmptyException, CsvConstraintViolationException {
        if (this.required && StringUtils.isBlank(value)) {
            throw new CsvRequiredFieldEmptyException(bean2.getClass(), this.field, String.format(ResourceBundle.getBundle("opencsv", this.errorLocale).getString("required.field.empty"), this.field.getName()));
        }
        this.assignValueToField(bean2, this.convert(value), header);
    }

    @Override
    public Object getFieldValue(T bean2) {
        Object o = null;
        try {
            Method getterMethod = this.getReadMethod(bean2);
            try {
                o = getterMethod.invoke(bean2, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {}
        }
        catch (NoSuchMethodException | SecurityException e1) {
            o = this.readWithoutGetter(bean2);
        }
        return o;
    }

    protected Method getReadMethod(T bean2) throws NoSuchMethodException {
        String getterName = "get" + Character.toUpperCase(this.field.getName().charAt(0)) + this.field.getName().substring(1);
        return bean2.getClass().getMethod(getterName, new Class[0]);
    }

    protected Method getWriteMethod(T bean2) throws NoSuchMethodException {
        String setterName = "set" + Character.toUpperCase(this.field.getName().charAt(0)) + this.field.getName().substring(1);
        return bean2.getClass().getMethod(setterName, this.field.getType());
    }

    @Override
    public Object[] indexAndSplitMultivaluedField(Object value, Object index) throws CsvDataTypeMismatchException {
        return new Object[]{value};
    }

    protected boolean isFieldEmptyForWrite(Object value) {
        return value == null;
    }

    protected void assignValueToField(T bean2, Object obj, String header) throws CsvDataTypeMismatchException {
        if (obj != null) {
            try {
                Method setterMethod = this.getWriteMethod(bean2);
                try {
                    setterMethod.invoke(bean2, obj);
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (InvocationTargetException e) {
                    CsvBeanIntrospectionException csve = new CsvBeanIntrospectionException(bean2, this.field, e.getLocalizedMessage());
                    csve.initCause(e);
                    throw csve;
                }
            }
            catch (NoSuchMethodException | SecurityException e1) {
                this.writeWithoutSetter(bean2, obj);
            }
        }
    }

    protected void writeWithoutSetter(T bean2, Object obj) throws CsvDataTypeMismatchException {
        try {
            FieldUtils.writeField(this.field, bean2, obj, true);
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (IllegalArgumentException e2) {
            CsvDataTypeMismatchException csve = new CsvDataTypeMismatchException(obj, this.field.getType());
            csve.initCause(e2);
            throw csve;
        }
    }

    protected Object readWithoutGetter(T bean2) {
        Object o = null;
        try {
            o = FieldUtils.readField(this.field, bean2, true);
        }
        catch (IllegalAccessException | IllegalArgumentException exception) {
            // empty catch block
        }
        return o;
    }

    protected abstract Object convert(String var1) throws CsvDataTypeMismatchException, CsvConstraintViolationException;

    @Override
    public final String[] write(T bean2, Object index) throws CsvDataTypeMismatchException, CsvRequiredFieldEmptyException {
        String[] result = ArrayUtils.EMPTY_STRING_ARRAY;
        if (bean2 != null && this.field != null) {
            Object value;
            if (this.propUtils == null) {
                this.propUtils = new PropertyUtilsBean();
            }
            try {
                value = this.propUtils.getSimpleProperty(bean2, this.field.getName());
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                CsvBeanIntrospectionException csve = new CsvBeanIntrospectionException(bean2, this.field);
                csve.initCause(e);
                throw csve;
            }
            if (this.isFieldEmptyForWrite(value) && this.required) {
                throw new CsvRequiredFieldEmptyException(bean2.getClass(), this.field, String.format(ResourceBundle.getBundle("opencsv", this.errorLocale).getString("required.field.empty"), this.field.getName()));
            }
            Object[] multivalues = this.indexAndSplitMultivaluedField(value, index);
            String[] intermediateResult = new String[multivalues.length];
            try {
                for (int i = 0; i < multivalues.length; ++i) {
                    intermediateResult[i] = this.convertToWrite(multivalues[i]);
                }
                result = intermediateResult;
            }
            catch (CsvDataTypeMismatchException e) {
                CsvDataTypeMismatchException csve = new CsvDataTypeMismatchException(bean2, this.field.getType(), e.getMessage());
                csve.initCause(e.getCause());
                throw csve;
            }
            catch (CsvRequiredFieldEmptyException e) {
                CsvRequiredFieldEmptyException csve = new CsvRequiredFieldEmptyException(bean2.getClass(), this.field, e.getMessage());
                csve.initCause(e.getCause());
                throw csve;
            }
        }
        return result;
    }

    protected String convertToWrite(Object value) throws CsvDataTypeMismatchException, CsvRequiredFieldEmptyException {
        return Objects.toString(value, "");
    }
}

