/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.servlet.htmlunit;

import com.gargoylesoftware.htmlunit.CookieManager;
import com.gargoylesoftware.htmlunit.FormEncodingType;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebRequest;
import com.gargoylesoftware.htmlunit.util.Cookie;
import com.gargoylesoftware.htmlunit.util.NameValuePair;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import org.springframework.beans.Mergeable;
import org.springframework.lang.Nullable;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpSession;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.SmartRequestBuilder;
import org.springframework.test.web.servlet.htmlunit.MockMvcWebConnection;
import org.springframework.test.web.servlet.request.MockHttpServletRequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.request.RequestPostProcessor;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

final class HtmlUnitRequestBuilder
implements RequestBuilder,
Mergeable {
    private final Map<String, MockHttpSession> sessions;
    private final WebClient webClient;
    private final WebRequest webRequest;
    @Nullable
    private String contextPath;
    @Nullable
    private RequestBuilder parentBuilder;
    @Nullable
    private SmartRequestBuilder parentPostProcessor;
    @Nullable
    private RequestPostProcessor forwardPostProcessor;

    public HtmlUnitRequestBuilder(Map<String, MockHttpSession> sessions, WebClient webClient, WebRequest webRequest) {
        Assert.notNull(sessions, "Sessions Map must not be null");
        Assert.notNull((Object)webClient, "WebClient must not be null");
        Assert.notNull((Object)webRequest, "WebRequest must not be null");
        this.sessions = sessions;
        this.webClient = webClient;
        this.webRequest = webRequest;
    }

    @Override
    public MockHttpServletRequest buildRequest(ServletContext servletContext) {
        Charset charset = this.getCharset();
        String httpMethod = this.webRequest.getHttpMethod().name();
        UriComponents uriComponents = this.uriComponents();
        String path = uriComponents.getPath();
        HtmlUnitMockHttpServletRequest request = new HtmlUnitMockHttpServletRequest(servletContext, httpMethod, path != null ? path : "");
        this.parent(request, this.parentBuilder);
        String host = uriComponents.getHost();
        request.setServerName(host != null ? host : "");
        this.authType(request);
        request.setCharacterEncoding(charset.name());
        this.content(request, charset);
        this.contextPath(request, uriComponents);
        this.contentType(request);
        this.cookies(request);
        this.headers(request);
        this.locales(request);
        this.servletPath(uriComponents, request);
        this.params(request, uriComponents);
        this.ports(uriComponents, request);
        request.setProtocol("HTTP/1.1");
        request.setQueryString(uriComponents.getQuery());
        String scheme = uriComponents.getScheme();
        request.setScheme(scheme != null ? scheme : "");
        request.setPathInfo(null);
        return this.postProcess(request);
    }

    private Charset getCharset() {
        Charset charset = this.webRequest.getCharset();
        return charset != null ? charset : StandardCharsets.ISO_8859_1;
    }

    private MockHttpServletRequest postProcess(MockHttpServletRequest request) {
        if (this.parentPostProcessor != null) {
            request = this.parentPostProcessor.postProcessRequest(request);
        }
        if (this.forwardPostProcessor != null) {
            request = this.forwardPostProcessor.postProcessRequest(request);
        }
        return request;
    }

    private void parent(MockHttpServletRequest request, @Nullable RequestBuilder parent) {
        Object attrValue;
        if (parent == null) {
            return;
        }
        MockHttpServletRequest parentRequest = parent.buildRequest(request.getServletContext());
        HttpSession parentSession = parentRequest.getSession(false);
        if (parentSession != null) {
            HttpSession localSession = request.getSession();
            Assert.state(localSession != null, "No local HttpSession");
            Enumeration<String> attrNames = parentSession.getAttributeNames();
            while (attrNames.hasMoreElements()) {
                String attrName = attrNames.nextElement();
                attrValue = parentSession.getAttribute(attrName);
                localSession.setAttribute(attrName, attrValue);
            }
        }
        Enumeration<String> headerNames = parentRequest.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String attrName = headerNames.nextElement();
            Enumeration<String> attrValues = parentRequest.getHeaders(attrName);
            while (attrValues.hasMoreElements()) {
                attrValue = attrValues.nextElement();
                request.addHeader(attrName, attrValue);
            }
        }
        Map<String, String[]> parentParams = parentRequest.getParameterMap();
        parentParams.forEach(request::addParameter);
        Object[] parentCookies = parentRequest.getCookies();
        if (!ObjectUtils.isEmpty(parentCookies)) {
            request.setCookies((javax.servlet.http.Cookie[])parentCookies);
        }
        Enumeration<String> parentAttrNames = parentRequest.getAttributeNames();
        while (parentAttrNames.hasMoreElements()) {
            String parentAttrName = parentAttrNames.nextElement();
            request.setAttribute(parentAttrName, parentRequest.getAttribute(parentAttrName));
        }
    }

    public void setContextPath(@Nullable String contextPath) {
        MockMvcWebConnection.validateContextPath(contextPath);
        this.contextPath = contextPath;
    }

    public void setForwardPostProcessor(RequestPostProcessor forwardPostProcessor) {
        this.forwardPostProcessor = forwardPostProcessor;
    }

    private void authType(MockHttpServletRequest request) {
        String authorization = this.header("Authorization");
        String[] authSplit = StringUtils.split(authorization, ": ");
        if (authSplit != null) {
            request.setAuthType(authSplit[0]);
        }
    }

    private void content(MockHttpServletRequest request, Charset charset) {
        String requestBody = this.webRequest.getRequestBody();
        if (requestBody == null) {
            return;
        }
        request.setContent(requestBody.getBytes(charset));
    }

    private void contentType(MockHttpServletRequest request) {
        FormEncodingType encodingType;
        String contentType = this.header("Content-Type");
        if (contentType == null && (encodingType = this.webRequest.getEncodingType()) != null) {
            contentType = encodingType.getName();
        }
        request.setContentType(contentType != null ? contentType : "*/*");
    }

    private void contextPath(MockHttpServletRequest request, UriComponents uriComponents) {
        if (this.contextPath == null) {
            List pathSegments = uriComponents.getPathSegments();
            if (pathSegments.isEmpty()) {
                request.setContextPath("");
            } else {
                request.setContextPath("/" + (String)pathSegments.get(0));
            }
        } else {
            String path = uriComponents.getPath();
            Assert.isTrue(path != null && path.startsWith(this.contextPath), () -> "\"" + uriComponents.getPath() + "\" should start with context path \"" + this.contextPath + "\"");
            request.setContextPath(this.contextPath);
        }
    }

    private void cookies(MockHttpServletRequest request) {
        ArrayList<javax.servlet.http.Cookie> cookies = new ArrayList<javax.servlet.http.Cookie>();
        String cookieHeaderValue = this.header("Cookie");
        if (cookieHeaderValue != null) {
            StringTokenizer tokens = new StringTokenizer(cookieHeaderValue, "=;");
            while (tokens.hasMoreTokens()) {
                String cookieName = tokens.nextToken().trim();
                Assert.isTrue(tokens.hasMoreTokens(), () -> "Expected value for cookie name '" + cookieName + "': full cookie header was [" + cookieHeaderValue + "]");
                String cookieValue = tokens.nextToken().trim();
                this.processCookie(request, cookies, new javax.servlet.http.Cookie(cookieName, cookieValue));
            }
        }
        Set managedCookies = this.webClient.getCookies(this.webRequest.getUrl());
        for (Cookie cookie : managedCookies) {
            this.processCookie(request, cookies, new javax.servlet.http.Cookie(cookie.getName(), cookie.getValue()));
        }
        javax.servlet.http.Cookie[] parentCookies = request.getCookies();
        if (parentCookies != null) {
            for (javax.servlet.http.Cookie cookie : parentCookies) {
                cookies.add(cookie);
            }
        }
        if (!ObjectUtils.isEmpty(cookies)) {
            request.setCookies(cookies.toArray(new javax.servlet.http.Cookie[0]));
        }
    }

    private void processCookie(MockHttpServletRequest request, List<javax.servlet.http.Cookie> cookies, javax.servlet.http.Cookie cookie) {
        cookies.add(cookie);
        if ("JSESSIONID".equals(cookie.getName())) {
            request.setRequestedSessionId(cookie.getValue());
            request.setSession(this.httpSession(request, cookie.getValue()));
        }
    }

    @Nullable
    private String header(String headerName) {
        return (String)this.webRequest.getAdditionalHeaders().get(headerName);
    }

    private void headers(MockHttpServletRequest request) {
        this.webRequest.getAdditionalHeaders().forEach(request::addHeader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MockHttpSession httpSession(MockHttpServletRequest request, String sessionid) {
        MockHttpSession session;
        Map<String, MockHttpSession> map = this.sessions;
        synchronized (map) {
            session = this.sessions.get(sessionid);
            if (session == null) {
                session = new HtmlUnitMockHttpSession(request, sessionid);
                session.setNew(true);
                Map<String, MockHttpSession> map2 = this.sessions;
                synchronized (map2) {
                    this.sessions.put(sessionid, session);
                }
                this.addSessionCookie(request, sessionid);
            } else {
                session.setNew(false);
            }
        }
        return session;
    }

    private void addSessionCookie(MockHttpServletRequest request, String sessionid) {
        this.getCookieManager().addCookie(this.createCookie(request, sessionid));
    }

    private void removeSessionCookie(MockHttpServletRequest request, String sessionid) {
        this.getCookieManager().removeCookie(this.createCookie(request, sessionid));
    }

    private Cookie createCookie(MockHttpServletRequest request, String sessionid) {
        return new Cookie(request.getServerName(), "JSESSIONID", sessionid, request.getContextPath() + "/", null, request.isSecure(), true);
    }

    private void locales(MockHttpServletRequest request) {
        String locale = this.header("Accept-Language");
        if (locale == null) {
            request.addPreferredLocale(Locale.getDefault());
        }
    }

    private void params(MockHttpServletRequest request, UriComponents uriComponents) {
        uriComponents.getQueryParams().forEach((name, values) -> {
            String urlDecodedName = this.urlDecode((String)name);
            values.forEach(value -> {
                value = value != null ? this.urlDecode((String)value) : "";
                request.addParameter(urlDecodedName, (String)value);
            });
        });
        for (NameValuePair param : this.webRequest.getRequestParameters()) {
            request.addParameter(param.getName(), param.getValue());
        }
    }

    private String urlDecode(String value) {
        try {
            return URLDecoder.decode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new IllegalStateException(ex);
        }
    }

    private void servletPath(MockHttpServletRequest request, String requestPath) {
        String servletPath = requestPath.substring(request.getContextPath().length());
        request.setServletPath(servletPath);
    }

    private void servletPath(UriComponents uriComponents, MockHttpServletRequest request) {
        String path;
        if ("".equals(request.getPathInfo())) {
            request.setPathInfo(null);
        }
        this.servletPath(request, (path = uriComponents.getPath()) != null ? path : "");
    }

    private void ports(UriComponents uriComponents, MockHttpServletRequest request) {
        int serverPort = uriComponents.getPort();
        request.setServerPort(serverPort);
        if (serverPort == -1) {
            int portConnection = this.webRequest.getUrl().getDefaultPort();
            request.setLocalPort(serverPort);
            request.setRemotePort(portConnection);
        } else {
            request.setRemotePort(serverPort);
        }
    }

    private UriComponents uriComponents() {
        URL url = this.webRequest.getUrl();
        return UriComponentsBuilder.fromUriString((String)url.toExternalForm()).build();
    }

    @Override
    public boolean isMergeEnabled() {
        return true;
    }

    @Override
    public Object merge(@Nullable Object parent) {
        if (parent instanceof RequestBuilder) {
            if (parent instanceof MockHttpServletRequestBuilder) {
                MockHttpServletRequestBuilder copiedParent = MockMvcRequestBuilders.get("/", new Object[0]);
                copiedParent.merge(parent);
                this.parentBuilder = copiedParent;
            } else {
                this.parentBuilder = (RequestBuilder)parent;
            }
            if (parent instanceof SmartRequestBuilder) {
                this.parentPostProcessor = (SmartRequestBuilder)parent;
            }
        }
        return this;
    }

    private CookieManager getCookieManager() {
        return this.webClient.getCookieManager();
    }

    private final class HtmlUnitMockHttpSession
    extends MockHttpSession {
        private final MockHttpServletRequest request;

        public HtmlUnitMockHttpSession(MockHttpServletRequest request) {
            super(request.getServletContext());
            this.request = request;
        }

        private HtmlUnitMockHttpSession(MockHttpServletRequest request, String id) {
            super(request.getServletContext(), id);
            this.request = request;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void invalidate() {
            super.invalidate();
            Map map = HtmlUnitRequestBuilder.this.sessions;
            synchronized (map) {
                HtmlUnitRequestBuilder.this.sessions.remove(this.getId());
            }
            HtmlUnitRequestBuilder.this.removeSessionCookie(this.request, this.getId());
        }
    }

    private final class HtmlUnitMockHttpServletRequest
    extends MockHttpServletRequest {
        public HtmlUnitMockHttpServletRequest(ServletContext servletContext, String method, String requestURI) {
            super(servletContext, method, requestURI);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public HttpSession getSession(boolean create) {
            HttpSession session = super.getSession(false);
            if (session == null && create) {
                HtmlUnitMockHttpSession newSession = new HtmlUnitMockHttpSession(this);
                this.setSession(newSession);
                newSession.setNew(true);
                String sessionid = newSession.getId();
                Map map = HtmlUnitRequestBuilder.this.sessions;
                synchronized (map) {
                    HtmlUnitRequestBuilder.this.sessions.put(sessionid, newSession);
                }
                HtmlUnitRequestBuilder.this.addSessionCookie(this, sessionid);
                session = newSession;
            }
            return session;
        }
    }
}

