/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.reactive.server;

import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseCookie;
import org.springframework.http.client.reactive.ClientHttpRequest;
import org.springframework.http.client.reactive.ClientHttpResponse;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.MultiValueMap;
import org.springframework.util.ObjectUtils;
import reactor.core.publisher.MonoProcessor;

public class ExchangeResult {
    private static final List<MediaType> PRINTABLE_MEDIA_TYPES = Arrays.asList(MediaType.APPLICATION_JSON, MediaType.APPLICATION_XML, MediaType.parseMediaType((String)"text/*"), MediaType.APPLICATION_FORM_URLENCODED);
    private final ClientHttpRequest request;
    private final ClientHttpResponse response;
    private final MonoProcessor<byte[]> requestBody;
    private final MonoProcessor<byte[]> responseBody;
    @Nullable
    private final String uriTemplate;

    ExchangeResult(ClientHttpRequest request, ClientHttpResponse response, MonoProcessor<byte[]> requestBody, MonoProcessor<byte[]> responseBody, @Nullable String uriTemplate) {
        Assert.notNull((Object)request, "ClientHttpRequest is required");
        Assert.notNull((Object)response, "ClientHttpResponse is required");
        Assert.notNull(requestBody, "'requestBody' is required");
        Assert.notNull(responseBody, "'responseBody' is required");
        this.request = request;
        this.response = response;
        this.requestBody = requestBody;
        this.responseBody = responseBody;
        this.uriTemplate = uriTemplate;
    }

    ExchangeResult(ExchangeResult other) {
        this.request = other.request;
        this.response = other.response;
        this.requestBody = other.requestBody;
        this.responseBody = other.responseBody;
        this.uriTemplate = other.uriTemplate;
    }

    public HttpMethod getMethod() {
        return this.request.getMethod();
    }

    public URI getUrl() {
        return this.request.getURI();
    }

    @Nullable
    public String getUriTemplate() {
        return this.uriTemplate;
    }

    public HttpHeaders getRequestHeaders() {
        return this.request.getHeaders();
    }

    @Nullable
    public byte[] getRequestBodyContent() {
        MonoProcessor<byte[]> body = this.requestBody;
        Assert.isTrue(body.isTerminated(), "Request body incomplete.");
        return (byte[])body.block(Duration.ZERO);
    }

    public HttpStatus getStatus() {
        return this.response.getStatusCode();
    }

    public HttpHeaders getResponseHeaders() {
        return this.response.getHeaders();
    }

    public MultiValueMap<String, ResponseCookie> getResponseCookies() {
        return this.response.getCookies();
    }

    @Nullable
    public byte[] getResponseBodyContent() {
        MonoProcessor<byte[]> body = this.responseBody;
        Assert.state(body.isTerminated(), "Response body incomplete");
        return (byte[])body.block(Duration.ZERO);
    }

    public void assertWithDiagnostics(Runnable assertion) {
        try {
            assertion.run();
        }
        catch (AssertionError ex) {
            throw new AssertionError(((Throwable)((Object)ex)).getMessage() + "\n" + this, (Throwable)((Object)ex));
        }
    }

    public String toString() {
        return "\n> " + this.getMethod() + " " + this.getUrl() + "\n> " + this.formatHeaders(this.getRequestHeaders(), "\n> ") + "\n\n" + this.formatBody(this.getRequestHeaders().getContentType(), this.requestBody) + "\n\n< " + this.getStatus() + " " + this.getStatusReason() + "\n< " + this.formatHeaders(this.getResponseHeaders(), "\n< ") + "\n\n" + this.formatBody(this.getResponseHeaders().getContentType(), this.responseBody) + "\n";
    }

    private String getStatusReason() {
        return this.getStatus().getReasonPhrase();
    }

    private String formatHeaders(HttpHeaders headers, String delimiter) {
        return headers.entrySet().stream().map(entry -> (String)entry.getKey() + ": " + entry.getValue()).collect(Collectors.joining(delimiter));
    }

    private String formatBody(@Nullable MediaType contentType, MonoProcessor<byte[]> body) {
        if (body.isSuccess()) {
            byte[] bytes = (byte[])body.block(Duration.ZERO);
            if (ObjectUtils.isEmpty((Object)bytes)) {
                return "No content";
            }
            if (contentType == null) {
                return "Unknown content type (" + bytes.length + " bytes)";
            }
            Charset charset = contentType.getCharset();
            if (charset != null) {
                return new String(bytes, charset);
            }
            if (PRINTABLE_MEDIA_TYPES.stream().anyMatch(arg_0 -> ((MediaType)contentType).isCompatibleWith(arg_0))) {
                return new String(bytes, StandardCharsets.UTF_8);
            }
            return "Unknown charset (" + bytes.length + " bytes)";
        }
        if (body.isError()) {
            return "I/O failure: " + body.getError();
        }
        return "Content not available yet";
    }
}

