/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.datasource.init;

import java.sql.Connection;
import javax.sql.DataSource;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.jdbc.datasource.init.DatabasePopulator;
import org.springframework.jdbc.datasource.init.ScriptException;
import org.springframework.jdbc.datasource.init.UncategorizedScriptException;
import org.springframework.util.Assert;

public abstract class DatabasePopulatorUtils {
    public static void execute(DatabasePopulator populator, DataSource dataSource) throws DataAccessException {
        Assert.notNull((Object)populator, "DatabasePopulator must not be null");
        Assert.notNull((Object)dataSource, "DataSource must not be null");
        try {
            Connection connection = DataSourceUtils.getConnection(dataSource);
            try {
                populator.populate(connection);
            }
            finally {
                DataSourceUtils.releaseConnection(connection, dataSource);
            }
        }
        catch (Throwable ex) {
            if (ex instanceof ScriptException) {
                throw (ScriptException)ex;
            }
            throw new UncategorizedScriptException("Failed to execute database script", ex);
        }
    }
}

