/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.firefox;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.openqa.selenium.Platform;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.firefox.FirefoxProfile;
import org.openqa.selenium.io.FileHandler;
import org.openqa.selenium.io.TemporaryFilesystem;

public class ProfilesIni {
    private Map<String, File> profiles;

    public ProfilesIni() {
        File appData = this.locateAppDataDirectory(Platform.getCurrent());
        this.profiles = this.readProfiles(appData);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Map<String, File> readProfiles(File appData) {
        HashMap<String, File> toReturn = new HashMap<String, File>();
        File profilesIni = new File(appData, "profiles.ini");
        if (!profilesIni.exists()) {
            return toReturn;
        }
        boolean isRelative = true;
        String name = null;
        String path = null;
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(profilesIni));
            String line = reader.readLine();
            while (line != null) {
                if (line.startsWith("[Profile")) {
                    File profile2 = this.newProfile(name, appData, path, isRelative);
                    if (profile2 != null) {
                        toReturn.put(name, profile2);
                    }
                    name = null;
                    path = null;
                } else if (line.startsWith("Name=")) {
                    name = line.substring("Name=".length());
                } else if (line.startsWith("IsRelative=")) {
                    isRelative = line.endsWith("1");
                } else if (line.startsWith("Path=")) {
                    path = line.substring("Path=".length());
                }
                line = reader.readLine();
            }
        }
        catch (IOException e) {
            try {
                throw new WebDriverException(e);
            }
            catch (Throwable throwable) {
                try {
                    if (reader == null) throw throwable;
                    File profile4 = this.newProfile(name, appData, path, isRelative);
                    if (profile4 != null) {
                        toReturn.put(name, profile4);
                    }
                    reader.close();
                    throw throwable;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        try {
            if (reader == null) return toReturn;
            File profile3 = this.newProfile(name, appData, path, isRelative);
            if (profile3 != null) {
                toReturn.put(name, profile3);
            }
            reader.close();
            return toReturn;
        }
        catch (IOException profile3) {
            return toReturn;
        }
    }

    protected File newProfile(String name, File appData, String path, boolean isRelative) {
        if (name != null && path != null) {
            File profileDir = isRelative ? new File(appData, path) : new File(path);
            return profileDir;
        }
        return null;
    }

    public FirefoxProfile getProfile(String profileName) {
        File profileDir = this.profiles.get(profileName);
        if (profileDir == null) {
            return null;
        }
        File tempDir = TemporaryFilesystem.getDefaultTmpFS().createTempDir("userprofile", "copy");
        try {
            FileHandler.copy(profileDir, tempDir);
            File compreg = new File(tempDir, "compreg.dat");
            if (compreg.exists() && !compreg.delete()) {
                throw new WebDriverException("Cannot delete file from copy of profile " + profileName);
            }
        }
        catch (IOException e) {
            throw new WebDriverException(e);
        }
        return new FirefoxProfile(tempDir);
    }

    protected File locateAppDataDirectory(Platform os) {
        File appData = os.is(Platform.WINDOWS) ? new File(MessageFormat.format("{0}\\Mozilla\\Firefox", System.getenv("APPDATA"))) : (os.is(Platform.MAC) ? new File(MessageFormat.format("{0}/Library/Application Support/Firefox", System.getenv("HOME"))) : new File(MessageFormat.format("{0}/.mozilla/firefox", System.getenv("HOME"))));
        if (!appData.exists()) {
            return null;
        }
        if (!appData.isDirectory()) {
            throw new WebDriverException("The discovered user firefox data directory (which normally contains the profiles) isn't a directory: " + appData.getAbsolutePath());
        }
        return appData;
    }
}

