/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.firefox;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.ImmutableCapabilities;
import org.openqa.selenium.MutableCapabilities;
import org.openqa.selenium.Proxy;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.firefox.FirefoxBinary;
import org.openqa.selenium.firefox.FirefoxOptions;
import org.openqa.selenium.firefox.FirefoxProfile;
import org.openqa.selenium.firefox.GeckoDriverService;
import org.openqa.selenium.firefox.HasExtensions;
import org.openqa.selenium.firefox.XpiDriverService;
import org.openqa.selenium.html5.LocalStorage;
import org.openqa.selenium.html5.SessionStorage;
import org.openqa.selenium.html5.WebStorage;
import org.openqa.selenium.remote.CommandExecutor;
import org.openqa.selenium.remote.CommandInfo;
import org.openqa.selenium.remote.FileDetector;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.remote.html5.RemoteWebStorage;
import org.openqa.selenium.remote.http.HttpMethod;
import org.openqa.selenium.remote.service.DriverCommandExecutor;
import org.openqa.selenium.remote.service.DriverService;

public class FirefoxDriver
extends RemoteWebDriver
implements WebStorage,
HasExtensions {
    public static final String BINARY = "firefox_binary";
    public static final String PROFILE = "firefox_profile";
    public static final String MARIONETTE = "marionette";
    private static final ImmutableMap<String, CommandInfo> EXTRA_COMMANDS = ImmutableMap.of(ExtraCommands.INSTALL_EXTENSION, new CommandInfo("/session/:sessionId/moz/addon/install", HttpMethod.POST), ExtraCommands.UNINSTALL_EXTENSION, new CommandInfo("/session/:sessionId/moz/addon/uninstall", HttpMethod.POST));
    protected FirefoxBinary binary;
    private RemoteWebStorage webStorage = new RemoteWebStorage(this.getExecuteMethod());

    public FirefoxDriver() {
        this(new FirefoxOptions());
    }

    @Deprecated
    public FirefoxDriver(Capabilities desiredCapabilities) {
        this(new FirefoxOptions(Objects.requireNonNull(desiredCapabilities, "No capabilities seen")));
    }

    @Deprecated
    public FirefoxDriver(GeckoDriverService service, Capabilities desiredCapabilities) {
        this(Objects.requireNonNull(service, "No geckodriver service provided"), new FirefoxOptions(desiredCapabilities));
    }

    public FirefoxDriver(FirefoxOptions options) {
        super(FirefoxDriver.toExecutor(options), FirefoxDriver.dropCapabilities(options));
    }

    public FirefoxDriver(GeckoDriverService service) {
        super(new FirefoxDriverCommandExecutor(service), (Capabilities)new FirefoxOptions());
    }

    public FirefoxDriver(XpiDriverService service) {
        super(new FirefoxDriverCommandExecutor(service), (Capabilities)new FirefoxOptions());
    }

    public FirefoxDriver(GeckoDriverService service, FirefoxOptions options) {
        super(new FirefoxDriverCommandExecutor(service), FirefoxDriver.dropCapabilities(options));
    }

    public FirefoxDriver(XpiDriverService service, FirefoxOptions options) {
        super(new FirefoxDriverCommandExecutor(service), FirefoxDriver.dropCapabilities(options));
    }

    private static CommandExecutor toExecutor(FirefoxOptions options) {
        DriverService.Builder builder;
        Objects.requireNonNull(options, "No options to construct executor from");
        if (!Boolean.parseBoolean(System.getProperty("webdriver.firefox.marionette", "true")) || options.isLegacy()) {
            FirefoxProfile profile2 = options.getProfile();
            if (profile2 == null) {
                profile2 = new FirefoxProfile();
                options.setCapability(PROFILE, profile2);
            }
            builder = XpiDriverService.builder().withBinary(options.getBinary()).withProfile(profile2);
        } else {
            builder = new GeckoDriverService.Builder().usingFirefoxBinary(options.getBinary());
        }
        return new FirefoxDriverCommandExecutor((DriverService)builder.build());
    }

    @Override
    public void setFileDetector(FileDetector detector) {
        throw new WebDriverException("Setting the file detector only works on remote webdriver instances obtained via RemoteWebDriver");
    }

    @Override
    public LocalStorage getLocalStorage() {
        return this.webStorage.getLocalStorage();
    }

    @Override
    public SessionStorage getSessionStorage() {
        return this.webStorage.getSessionStorage();
    }

    private static boolean isLegacy(Capabilities desiredCapabilities) {
        Boolean forceMarionette = FirefoxDriver.forceMarionetteFromSystemProperty();
        if (forceMarionette != null) {
            return forceMarionette == false;
        }
        Object marionette = desiredCapabilities.getCapability(MARIONETTE);
        return marionette instanceof Boolean && (Boolean)marionette == false;
    }

    @Override
    public String installExtension(Path path) {
        return (String)this.execute(ExtraCommands.INSTALL_EXTENSION, ImmutableMap.of("path", path.toAbsolutePath().toString(), "temporary", false)).getValue();
    }

    @Override
    public void uninstallExtension(String extensionId) {
        this.execute(ExtraCommands.UNINSTALL_EXTENSION, Collections.singletonMap("id", extensionId));
    }

    private static Boolean forceMarionetteFromSystemProperty() {
        String useMarionette = System.getProperty("webdriver.firefox.marionette");
        if (useMarionette == null) {
            return null;
        }
        return Boolean.valueOf(useMarionette);
    }

    private static Capabilities dropCapabilities(Capabilities capabilities) {
        MutableCapabilities caps;
        if (capabilities == null) {
            return new ImmutableCapabilities();
        }
        if (FirefoxDriver.isLegacy(capabilities)) {
            HashSet<String> toRemove = Sets.newHashSet(BINARY, PROFILE);
            caps = new MutableCapabilities(Maps.filterKeys(capabilities.asMap(), key -> !toRemove.contains(key)));
        } else {
            caps = new MutableCapabilities(capabilities);
        }
        Proxy proxy = Proxy.extractFrom(capabilities);
        if (proxy != null) {
            caps.setCapability("proxy", proxy);
        }
        return caps;
    }

    private static class FirefoxDriverCommandExecutor
    extends DriverCommandExecutor {
        public FirefoxDriverCommandExecutor(DriverService service) {
            super(service, EXTRA_COMMANDS);
        }
    }

    private static class ExtraCommands {
        static String INSTALL_EXTENSION = "installExtension";
        static String UNINSTALL_EXTENSION = "uninstallExtension";

        private ExtraCommands() {
        }
    }

    public static final class SystemProperty {
        public static final String BROWSER_BINARY = "webdriver.firefox.bin";
        public static final String BROWSER_LOGFILE = "webdriver.firefox.logfile";
        public static final String BROWSER_LIBRARY_PATH = "webdriver.firefox.library.path";
        public static final String BROWSER_PROFILE = "webdriver.firefox.profile";
        public static final String DRIVER_XPI_PROPERTY = "webdriver.firefox.driver";
        public static final String DRIVER_USE_MARIONETTE = "webdriver.firefox.marionette";
    }
}

