/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.openqa.selenium.Capabilities;

public class Proxy {
    private ProxyType proxyType = ProxyType.UNSPECIFIED;
    private boolean autodetect = false;
    private String ftpProxy;
    private String httpProxy;
    private String noProxy;
    private String sslProxy;
    private String socksProxy;
    private Integer socksVersion;
    private String socksUsername;
    private String socksPassword;
    private String proxyAutoconfigUrl;

    public Proxy() {
    }

    public Proxy(Map<String, ?> raw) {
        if (raw.containsKey("proxyType") && raw.get("proxyType") != null) {
            this.setProxyType(ProxyType.valueOf(((String)raw.get("proxyType")).toUpperCase()));
        }
        if (raw.containsKey("ftpProxy") && raw.get("ftpProxy") != null) {
            this.setFtpProxy((String)raw.get("ftpProxy"));
        }
        if (raw.containsKey("httpProxy") && raw.get("httpProxy") != null) {
            this.setHttpProxy((String)raw.get("httpProxy"));
        }
        if (raw.containsKey("noProxy") && raw.get("noProxy") != null) {
            Object rawData = raw.get("noProxy");
            if (rawData instanceof List) {
                this.setNoProxy(String.join((CharSequence)", ", (List)rawData));
            } else {
                this.setNoProxy((String)rawData);
            }
        }
        if (raw.containsKey("sslProxy") && raw.get("sslProxy") != null) {
            this.setSslProxy((String)raw.get("sslProxy"));
        }
        if (raw.containsKey("socksProxy") && raw.get("socksProxy") != null) {
            this.setSocksProxy((String)raw.get("socksProxy"));
        }
        if (raw.containsKey("socksVersion") && raw.get("socksVersion") != null) {
            this.setSocksVersion((Integer)raw.get("socksVersion"));
        }
        if (raw.containsKey("socksUsername") && raw.get("socksUsername") != null) {
            this.setSocksUsername((String)raw.get("socksUsername"));
        }
        if (raw.containsKey("socksPassword") && raw.get("socksPassword") != null) {
            this.setSocksPassword((String)raw.get("socksPassword"));
        }
        if (raw.containsKey("proxyAutoconfigUrl") && raw.get("proxyAutoconfigUrl") != null) {
            this.setProxyAutoconfigUrl((String)raw.get("proxyAutoconfigUrl"));
        }
        if (raw.containsKey("autodetect") && raw.get("autodetect") != null) {
            this.setAutodetect((Boolean)raw.get("autodetect"));
        }
    }

    public Map<String, Object> toJson() {
        HashMap<String, Object> m3 = new HashMap<String, Object>();
        if (this.proxyType != ProxyType.UNSPECIFIED) {
            m3.put("proxyType", this.proxyType.toString());
        }
        if (this.ftpProxy != null) {
            m3.put("ftpProxy", this.ftpProxy);
        }
        if (this.httpProxy != null) {
            m3.put("httpProxy", this.httpProxy);
        }
        if (this.noProxy != null) {
            m3.put("noProxy", Arrays.asList(this.noProxy.split(",\\s*")));
        }
        if (this.sslProxy != null) {
            m3.put("sslProxy", this.sslProxy);
        }
        if (this.socksProxy != null) {
            m3.put("socksProxy", this.socksProxy);
        }
        if (this.socksVersion != null) {
            m3.put("socksVersion", this.socksVersion);
        }
        if (this.socksUsername != null) {
            m3.put("socksUsername", this.socksUsername);
        }
        if (this.socksPassword != null) {
            m3.put("socksPassword", this.socksPassword);
        }
        if (this.proxyAutoconfigUrl != null) {
            m3.put("proxyAutoconfigUrl", this.proxyAutoconfigUrl);
        }
        if (this.autodetect) {
            m3.put("autodetect", true);
        }
        return m3;
    }

    public ProxyType getProxyType() {
        return this.proxyType;
    }

    public Proxy setProxyType(ProxyType proxyType) {
        this.verifyProxyTypeCompatibility(proxyType);
        this.proxyType = proxyType;
        return this;
    }

    public boolean isAutodetect() {
        return this.autodetect;
    }

    public Proxy setAutodetect(boolean autodetect) {
        if (this.autodetect == autodetect) {
            return this;
        }
        if (autodetect) {
            this.verifyProxyTypeCompatibility(ProxyType.AUTODETECT);
            this.proxyType = ProxyType.AUTODETECT;
        } else {
            this.proxyType = ProxyType.UNSPECIFIED;
        }
        this.autodetect = autodetect;
        return this;
    }

    public String getFtpProxy() {
        return this.ftpProxy;
    }

    public Proxy setFtpProxy(String ftpProxy) {
        this.verifyProxyTypeCompatibility(ProxyType.MANUAL);
        this.proxyType = ProxyType.MANUAL;
        this.ftpProxy = ftpProxy;
        return this;
    }

    public String getHttpProxy() {
        return this.httpProxy;
    }

    public Proxy setHttpProxy(String httpProxy) {
        this.verifyProxyTypeCompatibility(ProxyType.MANUAL);
        this.proxyType = ProxyType.MANUAL;
        this.httpProxy = httpProxy;
        return this;
    }

    public String getNoProxy() {
        return this.noProxy;
    }

    public Proxy setNoProxy(String noProxy) {
        this.verifyProxyTypeCompatibility(ProxyType.MANUAL);
        this.proxyType = ProxyType.MANUAL;
        this.noProxy = noProxy;
        return this;
    }

    public String getSslProxy() {
        return this.sslProxy;
    }

    public Proxy setSslProxy(String sslProxy) {
        this.verifyProxyTypeCompatibility(ProxyType.MANUAL);
        this.proxyType = ProxyType.MANUAL;
        this.sslProxy = sslProxy;
        return this;
    }

    public String getSocksProxy() {
        return this.socksProxy;
    }

    public Proxy setSocksProxy(String socksProxy) {
        this.verifyProxyTypeCompatibility(ProxyType.MANUAL);
        this.proxyType = ProxyType.MANUAL;
        this.socksProxy = socksProxy;
        return this;
    }

    public Integer getSocksVersion() {
        return this.socksVersion;
    }

    public Proxy setSocksVersion(Integer socksVersion) {
        this.verifyProxyTypeCompatibility(ProxyType.MANUAL);
        this.proxyType = ProxyType.MANUAL;
        this.socksVersion = socksVersion;
        return this;
    }

    public String getSocksUsername() {
        return this.socksUsername;
    }

    public Proxy setSocksUsername(String username) {
        this.verifyProxyTypeCompatibility(ProxyType.MANUAL);
        this.proxyType = ProxyType.MANUAL;
        this.socksUsername = username;
        return this;
    }

    public String getSocksPassword() {
        return this.socksPassword;
    }

    public Proxy setSocksPassword(String password) {
        this.verifyProxyTypeCompatibility(ProxyType.MANUAL);
        this.proxyType = ProxyType.MANUAL;
        this.socksPassword = password;
        return this;
    }

    public String getProxyAutoconfigUrl() {
        return this.proxyAutoconfigUrl;
    }

    public Proxy setProxyAutoconfigUrl(String proxyAutoconfigUrl) {
        this.verifyProxyTypeCompatibility(ProxyType.PAC);
        this.proxyType = ProxyType.PAC;
        this.proxyAutoconfigUrl = proxyAutoconfigUrl;
        return this;
    }

    private void verifyProxyTypeCompatibility(ProxyType compatibleProxy) {
        if (this.proxyType != ProxyType.UNSPECIFIED && this.proxyType != compatibleProxy) {
            throw new IllegalStateException(String.format("Specified proxy type (%s) not compatible with current setting (%s)", new Object[]{compatibleProxy, this.proxyType}));
        }
    }

    public static Proxy extractFrom(Capabilities capabilities) {
        Object rawProxy = capabilities.getCapability("proxy");
        Proxy proxy = null;
        if (rawProxy != null) {
            if (rawProxy instanceof Proxy) {
                proxy = (Proxy)rawProxy;
            } else if (rawProxy instanceof Map) {
                proxy = new Proxy((Map)rawProxy);
            }
        }
        return proxy;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("Proxy(");
        switch (this.getProxyType()) {
            case AUTODETECT: 
            case DIRECT: 
            case MANUAL: 
            case SYSTEM: {
                builder.append(this.getProxyType().toString().toLowerCase());
                break;
            }
            case PAC: {
                builder.append("pac: ").append(this.getProxyAutoconfigUrl());
                break;
            }
        }
        String p = this.getFtpProxy();
        if (p != null) {
            builder.append(", ftp=").append(p);
        }
        if ((p = this.getHttpProxy()) != null) {
            builder.append(", http=").append(p);
        }
        if ((p = this.getSocksProxy()) != null) {
            builder.append(", socks=").append(p);
        }
        if ((p = this.getSslProxy()) != null) {
            builder.append(", ssl=").append(p);
        }
        builder.append(")");
        return builder.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Proxy proxy = (Proxy)o;
        return this.isAutodetect() == proxy.isAutodetect() && this.getProxyType() == proxy.getProxyType() && Objects.equals(this.getFtpProxy(), proxy.getFtpProxy()) && Objects.equals(this.getHttpProxy(), proxy.getHttpProxy()) && Objects.equals(this.getNoProxy(), proxy.getNoProxy()) && Objects.equals(this.getSslProxy(), proxy.getSslProxy()) && Objects.equals(this.getSocksProxy(), proxy.getSocksProxy()) && Objects.equals(this.getSocksVersion(), proxy.getSocksVersion()) && Objects.equals(this.getSocksUsername(), proxy.getSocksUsername()) && Objects.equals(this.getSocksPassword(), proxy.getSocksPassword()) && Objects.equals(this.getProxyAutoconfigUrl(), proxy.getProxyAutoconfigUrl());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getProxyType(), this.isAutodetect(), this.getFtpProxy(), this.getHttpProxy(), this.getNoProxy(), this.getSslProxy(), this.getSocksProxy(), this.getSocksVersion(), this.getSocksUsername(), this.getSocksPassword(), this.getProxyAutoconfigUrl()});
    }

    public static enum ProxyType {
        DIRECT,
        MANUAL,
        PAC,
        RESERVED_1,
        AUTODETECT,
        SYSTEM,
        UNSPECIFIED;

    }
}

