/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.shaded.freemarker.core;

import org.mapstruct.ap.shaded.freemarker.core.Dot;
import org.mapstruct.ap.shaded.freemarker.core.DynamicKeyName;
import org.mapstruct.ap.shaded.freemarker.core.Environment;
import org.mapstruct.ap.shaded.freemarker.core.Expression;
import org.mapstruct.ap.shaded.freemarker.core.Identifier;
import org.mapstruct.ap.shaded.freemarker.core._ErrorDescriptionBuilder;
import org.mapstruct.ap.shaded.freemarker.template.TemplateException;

public class InvalidReferenceException
extends TemplateException {
    static final InvalidReferenceException FAST_INSTANCE = new InvalidReferenceException("Invalid reference. Details are unavilable, as this should have been handled by an FTL construct. If it wasn't, that's problably a bug in FreeMarker.", null);
    private static final String[] TIP = new String[]{"If the failing expression is known to be legally refer to something that's null or missing, either specify a default value like myOptionalVar!myDefault, or use ", "<#if myOptionalVar??>", "when-present", "<#else>", "when-missing", "</#if>", ". (These only cover the last step of the expression; to cover the whole expression, use parenthesis: (myOptionalVar.foo)!myDefault, (myOptionalVar.foo)??"};
    private static final String TIP_NO_DOLAR = "Variable references must not start with \"$\", unless the \"$\" is really part of the variable name.";
    private static final String TIP_LAST_STEP_DOT = "It's the step after the last dot that caused this error, not those before it.";
    private static final String TIP_LAST_STEP_SQUARE_BRACKET = "It's the final [] step that caused this error, not those before it.";

    public InvalidReferenceException(Environment env) {
        super("Invalid reference: The expression has evaluated to null or refers to something that doesn't exist.", env);
    }

    public InvalidReferenceException(String description, Environment env) {
        super(description, env);
    }

    InvalidReferenceException(_ErrorDescriptionBuilder description, Environment env, Expression expression) {
        super(null, env, expression, description);
    }

    static InvalidReferenceException getInstance(Expression blamed, Environment env) {
        if (env != null && env.getFastInvalidReferenceExceptions()) {
            return FAST_INSTANCE;
        }
        if (blamed != null) {
            _ErrorDescriptionBuilder errDescBuilder = new _ErrorDescriptionBuilder("The following has evaluated to null or missing:").blame(blamed);
            if (InvalidReferenceException.endsWithDollarVariable(blamed)) {
                errDescBuilder.tips(new Object[]{TIP_NO_DOLAR, TIP});
            } else if (blamed instanceof Dot) {
                Object[] objectArray;
                String rho = ((Dot)blamed).getRHO();
                String nameFixTip = null;
                if ("size".equals(rho)) {
                    nameFixTip = "To query the size of a collection or map use ?size, like myList?size";
                } else if ("length".equals(rho)) {
                    nameFixTip = "To query the length of a string use ?length, like myString?size";
                }
                if (nameFixTip == null) {
                    Object[] objectArray2 = new Object[2];
                    objectArray2[0] = TIP_LAST_STEP_DOT;
                    objectArray = objectArray2;
                    objectArray2[1] = TIP;
                } else {
                    Object[] objectArray3 = new Object[3];
                    objectArray3[0] = TIP_LAST_STEP_DOT;
                    objectArray3[1] = nameFixTip;
                    objectArray = objectArray3;
                    objectArray3[2] = TIP;
                }
                errDescBuilder.tips(objectArray);
            } else if (blamed instanceof DynamicKeyName) {
                errDescBuilder.tips(new Object[]{TIP_LAST_STEP_SQUARE_BRACKET, TIP});
            } else {
                errDescBuilder.tip(TIP);
            }
            return new InvalidReferenceException(errDescBuilder, env, blamed);
        }
        return new InvalidReferenceException(env);
    }

    private static boolean endsWithDollarVariable(Expression blame) {
        return blame instanceof Identifier && ((Identifier)blame).getName().startsWith("$") || blame instanceof Dot && ((Dot)blame).getRHO().startsWith("$");
    }
}

