/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.shaded.freemarker.core;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import org.mapstruct.ap.shaded.freemarker.core.ArithmeticEngine;
import org.mapstruct.ap.shaded.freemarker.core.CustomAttribute;
import org.mapstruct.ap.shaded.freemarker.core.Environment;
import org.mapstruct.ap.shaded.freemarker.core.OptInTemplateClassResolver;
import org.mapstruct.ap.shaded.freemarker.core.ParseException;
import org.mapstruct.ap.shaded.freemarker.core.TemplateClassResolver;
import org.mapstruct.ap.shaded.freemarker.core._DelayedJQuote;
import org.mapstruct.ap.shaded.freemarker.core._ErrorDescriptionBuilder;
import org.mapstruct.ap.shaded.freemarker.core._MiscTemplateException;
import org.mapstruct.ap.shaded.freemarker.core._ObjectBuilderSettingEvaluator;
import org.mapstruct.ap.shaded.freemarker.core._SettingEvaluationEnvironment;
import org.mapstruct.ap.shaded.freemarker.ext.beans.BeansWrapper;
import org.mapstruct.ap.shaded.freemarker.template.Configuration;
import org.mapstruct.ap.shaded.freemarker.template.ObjectWrapper;
import org.mapstruct.ap.shaded.freemarker.template.TemplateException;
import org.mapstruct.ap.shaded.freemarker.template.TemplateExceptionHandler;
import org.mapstruct.ap.shaded.freemarker.template.Version;
import org.mapstruct.ap.shaded.freemarker.template._TemplateAPI;
import org.mapstruct.ap.shaded.freemarker.template.utility.NullArgumentException;
import org.mapstruct.ap.shaded.freemarker.template.utility.StringUtil;

public class Configurable {
    static final String C_TRUE_FALSE = "true,false";
    private static final String DEFAULT = "default";
    private static final String JVM_DEFAULT = "JVM default";
    public static final String LOCALE_KEY = "locale";
    public static final String NUMBER_FORMAT_KEY = "number_format";
    public static final String TIME_FORMAT_KEY = "time_format";
    public static final String DATE_FORMAT_KEY = "date_format";
    public static final String DATETIME_FORMAT_KEY = "datetime_format";
    public static final String TIME_ZONE_KEY = "time_zone";
    public static final String SQL_DATE_AND_TIME_TIME_ZONE_KEY = "sql_date_and_time_time_zone";
    public static final String CLASSIC_COMPATIBLE_KEY = "classic_compatible";
    public static final String TEMPLATE_EXCEPTION_HANDLER_KEY = "template_exception_handler";
    public static final String ARITHMETIC_ENGINE_KEY = "arithmetic_engine";
    public static final String OBJECT_WRAPPER_KEY = "object_wrapper";
    public static final String BOOLEAN_FORMAT_KEY = "boolean_format";
    public static final String OUTPUT_ENCODING_KEY = "output_encoding";
    public static final String URL_ESCAPING_CHARSET_KEY = "url_escaping_charset";
    public static final String STRICT_BEAN_MODELS = "strict_bean_models";
    public static final String AUTO_FLUSH_KEY = "auto_flush";
    public static final String NEW_BUILTIN_CLASS_RESOLVER_KEY = "new_builtin_class_resolver";
    public static final String SHOW_ERROR_TIPS_KEY = "show_error_tips";
    private Configurable parent;
    private Properties properties;
    private HashMap customAttributes;
    private Locale locale;
    private String numberFormat;
    private String timeFormat;
    private String dateFormat;
    private String dateTimeFormat;
    private TimeZone timeZone;
    private TimeZone sqlDataAndTimeTimeZone;
    private boolean sqlDataAndTimeTimeZoneSet;
    private String booleanFormat;
    private String trueStringValue;
    private String falseStringValue;
    private Integer classicCompatible;
    private TemplateExceptionHandler templateExceptionHandler;
    private ArithmeticEngine arithmeticEngine;
    private ObjectWrapper objectWrapper;
    private String outputEncoding;
    private boolean outputEncodingSet;
    private String urlEscapingCharset;
    private boolean urlEscapingCharsetSet;
    private Boolean autoFlush;
    private TemplateClassResolver newBuiltinClassResolver;
    private Boolean showErrorTips;
    private static final String ALLOWED_CLASSES = "allowed_classes";
    private static final String TRUSTED_TEMPLATES = "trusted_templates";

    public Configurable() {
        this(Configuration.DEFAULT_INCOMPATIBLE_IMPROVEMENTS);
    }

    protected Configurable(Version incompatibleImprovements) {
        _TemplateAPI.checkVersionNotNullAndSupported(incompatibleImprovements);
        this.parent = null;
        this.locale = Locale.getDefault();
        this.timeZone = TimeZone.getDefault();
        this.sqlDataAndTimeTimeZone = null;
        this.numberFormat = "number";
        this.timeFormat = "";
        this.dateFormat = "";
        this.dateTimeFormat = "";
        this.classicCompatible = new Integer(0);
        this.templateExceptionHandler = TemplateExceptionHandler.DEBUG_HANDLER;
        this.arithmeticEngine = ArithmeticEngine.BIGDECIMAL_ENGINE;
        this.objectWrapper = Configuration.getDefaultObjectWrapper(incompatibleImprovements);
        this.autoFlush = Boolean.TRUE;
        this.newBuiltinClassResolver = TemplateClassResolver.UNRESTRICTED_RESOLVER;
        this.showErrorTips = Boolean.TRUE;
        this.properties = new Properties();
        this.properties.setProperty(LOCALE_KEY, this.locale.toString());
        this.properties.setProperty(TIME_FORMAT_KEY, this.timeFormat);
        this.properties.setProperty(DATE_FORMAT_KEY, this.dateFormat);
        this.properties.setProperty(DATETIME_FORMAT_KEY, this.dateTimeFormat);
        this.properties.setProperty(TIME_ZONE_KEY, this.timeZone.getID());
        this.properties.setProperty(SQL_DATE_AND_TIME_TIME_ZONE_KEY, String.valueOf(this.sqlDataAndTimeTimeZone));
        this.properties.setProperty(NUMBER_FORMAT_KEY, this.numberFormat);
        this.properties.setProperty(CLASSIC_COMPATIBLE_KEY, this.classicCompatible.toString());
        this.properties.setProperty(TEMPLATE_EXCEPTION_HANDLER_KEY, this.templateExceptionHandler.getClass().getName());
        this.properties.setProperty(ARITHMETIC_ENGINE_KEY, this.arithmeticEngine.getClass().getName());
        this.properties.setProperty(AUTO_FLUSH_KEY, this.autoFlush.toString());
        this.properties.setProperty(NEW_BUILTIN_CLASS_RESOLVER_KEY, this.newBuiltinClassResolver.getClass().getName());
        this.properties.setProperty(SHOW_ERROR_TIPS_KEY, this.showErrorTips.toString());
        this.setBooleanFormat(C_TRUE_FALSE);
        this.customAttributes = new HashMap();
    }

    public Configurable(Configurable parent) {
        this.parent = parent;
        this.locale = null;
        this.numberFormat = null;
        this.classicCompatible = null;
        this.templateExceptionHandler = null;
        this.properties = new Properties(parent.properties);
        this.customAttributes = new HashMap();
    }

    protected Object clone() throws CloneNotSupportedException {
        Configurable copy = (Configurable)super.clone();
        copy.properties = new Properties(this.properties);
        copy.customAttributes = (HashMap)this.customAttributes.clone();
        return copy;
    }

    public final Configurable getParent() {
        return this.parent;
    }

    final void setParent(Configurable parent) {
        this.parent = parent;
    }

    public void setClassicCompatible(boolean classicCompatibility) {
        this.classicCompatible = new Integer(classicCompatibility ? 1 : 0);
        this.properties.setProperty(CLASSIC_COMPATIBLE_KEY, this.classicCompatibilityIntToString(this.classicCompatible));
    }

    public void setClassicCompatibleAsInt(int classicCompatibility) {
        if (classicCompatibility < 0 || classicCompatibility > 2) {
            throw new IllegalArgumentException("Unsupported \"classicCompatibility\": " + classicCompatibility);
        }
        this.classicCompatible = new Integer(classicCompatibility);
    }

    private String classicCompatibilityIntToString(Integer i) {
        if (i == null) {
            return null;
        }
        if (i == 0) {
            return "false";
        }
        if (i == 1) {
            return "true";
        }
        return i.toString();
    }

    public boolean isClassicCompatible() {
        return this.classicCompatible != null ? this.classicCompatible != 0 : this.parent.isClassicCompatible();
    }

    public int getClassicCompatibleAsInt() {
        return this.classicCompatible != null ? this.classicCompatible.intValue() : this.parent.getClassicCompatibleAsInt();
    }

    public void setLocale(Locale locale) {
        NullArgumentException.check(LOCALE_KEY, locale);
        this.locale = locale;
        this.properties.setProperty(LOCALE_KEY, locale.toString());
    }

    public TimeZone getTimeZone() {
        return this.timeZone != null ? this.timeZone : this.parent.getTimeZone();
    }

    public void setTimeZone(TimeZone timeZone) {
        NullArgumentException.check("timeZone", timeZone);
        this.timeZone = timeZone;
        this.properties.setProperty(TIME_ZONE_KEY, timeZone.getID());
    }

    public void setSQLDateAndTimeTimeZone(TimeZone tz) {
        this.sqlDataAndTimeTimeZone = tz;
        this.sqlDataAndTimeTimeZoneSet = true;
        this.properties.setProperty(SQL_DATE_AND_TIME_TIME_ZONE_KEY, tz != null ? tz.getID() : "null");
    }

    public TimeZone getSQLDateAndTimeTimeZone() {
        return this.sqlDataAndTimeTimeZoneSet ? this.sqlDataAndTimeTimeZone : (this.parent != null ? this.parent.getSQLDateAndTimeTimeZone() : null);
    }

    public Locale getLocale() {
        return this.locale != null ? this.locale : this.parent.getLocale();
    }

    public void setNumberFormat(String numberFormat) {
        NullArgumentException.check("numberFormat", numberFormat);
        this.numberFormat = numberFormat;
        this.properties.setProperty(NUMBER_FORMAT_KEY, numberFormat);
    }

    public String getNumberFormat() {
        return this.numberFormat != null ? this.numberFormat : this.parent.getNumberFormat();
    }

    public void setBooleanFormat(String booleanFormat) {
        NullArgumentException.check("booleanFormat", booleanFormat);
        int commaIdx = booleanFormat.indexOf(44);
        if (commaIdx == -1) {
            throw new IllegalArgumentException("Setting value must be string that contains two comma-separated values for true and false, respectively.");
        }
        this.booleanFormat = booleanFormat;
        this.properties.setProperty(BOOLEAN_FORMAT_KEY, booleanFormat);
        if (booleanFormat.equals(C_TRUE_FALSE)) {
            this.trueStringValue = null;
            this.falseStringValue = null;
        } else {
            this.trueStringValue = booleanFormat.substring(0, commaIdx);
            this.falseStringValue = booleanFormat.substring(commaIdx + 1);
        }
    }

    public String getBooleanFormat() {
        return this.booleanFormat != null ? this.booleanFormat : this.parent.getBooleanFormat();
    }

    String formatBoolean(boolean value, boolean fallbackToTrueFalse) throws TemplateException {
        if (value) {
            String s2 = this.getTrueStringValue();
            if (s2 == null) {
                if (fallbackToTrueFalse) {
                    return "true";
                }
                throw new _MiscTemplateException(this.getNullBooleanFormatErrorDescription());
            }
            return s2;
        }
        String s3 = this.getFalseStringValue();
        if (s3 == null) {
            if (fallbackToTrueFalse) {
                return "false";
            }
            throw new _MiscTemplateException(this.getNullBooleanFormatErrorDescription());
        }
        return s3;
    }

    private _ErrorDescriptionBuilder getNullBooleanFormatErrorDescription() {
        return new _ErrorDescriptionBuilder(new Object[]{"Can't convert boolean to string automatically, because the \"", BOOLEAN_FORMAT_KEY, "\" setting was ", new _DelayedJQuote(this.getBooleanFormat()), this.getBooleanFormat().equals(C_TRUE_FALSE) ? ", which is the legacy default computer-language format, and hence isn't accepted." : "."}).tips(new Object[]{"If you just want \"true\"/\"false\" result as you are generting computer-language output, use \"?c\", like ${myBool?c}.", "You can write myBool?string('yes', 'no') and like to specify boolean formatting in place.", new Object[]{"If you need the same two values on most places, the programmers should set the \"", BOOLEAN_FORMAT_KEY, "\" setting to something like \"yes,no\"."}});
    }

    String getTrueStringValue() {
        return this.booleanFormat != null ? this.trueStringValue : (this.parent != null ? this.parent.getTrueStringValue() : null);
    }

    String getFalseStringValue() {
        return this.booleanFormat != null ? this.falseStringValue : (this.parent != null ? this.parent.getFalseStringValue() : null);
    }

    public void setTimeFormat(String timeFormat) {
        NullArgumentException.check("timeFormat", timeFormat);
        this.timeFormat = timeFormat;
        this.properties.setProperty(TIME_FORMAT_KEY, timeFormat);
    }

    public String getTimeFormat() {
        return this.timeFormat != null ? this.timeFormat : this.parent.getTimeFormat();
    }

    public void setDateFormat(String dateFormat) {
        NullArgumentException.check("dateFormat", dateFormat);
        this.dateFormat = dateFormat;
        this.properties.setProperty(DATE_FORMAT_KEY, dateFormat);
    }

    public String getDateFormat() {
        return this.dateFormat != null ? this.dateFormat : this.parent.getDateFormat();
    }

    public void setDateTimeFormat(String dateTimeFormat) {
        NullArgumentException.check("dateTimeFormat", dateTimeFormat);
        this.dateTimeFormat = dateTimeFormat;
        this.properties.setProperty(DATETIME_FORMAT_KEY, dateTimeFormat);
    }

    public String getDateTimeFormat() {
        return this.dateTimeFormat != null ? this.dateTimeFormat : this.parent.getDateTimeFormat();
    }

    public void setTemplateExceptionHandler(TemplateExceptionHandler templateExceptionHandler) {
        NullArgumentException.check("templateExceptionHandler", templateExceptionHandler);
        this.templateExceptionHandler = templateExceptionHandler;
        this.properties.setProperty(TEMPLATE_EXCEPTION_HANDLER_KEY, templateExceptionHandler.getClass().getName());
    }

    public TemplateExceptionHandler getTemplateExceptionHandler() {
        return this.templateExceptionHandler != null ? this.templateExceptionHandler : this.parent.getTemplateExceptionHandler();
    }

    public void setArithmeticEngine(ArithmeticEngine arithmeticEngine) {
        NullArgumentException.check("arithmeticEngine", arithmeticEngine);
        this.arithmeticEngine = arithmeticEngine;
        this.properties.setProperty(ARITHMETIC_ENGINE_KEY, arithmeticEngine.getClass().getName());
    }

    public ArithmeticEngine getArithmeticEngine() {
        return this.arithmeticEngine != null ? this.arithmeticEngine : this.parent.getArithmeticEngine();
    }

    public void setObjectWrapper(ObjectWrapper objectWrapper) {
        NullArgumentException.check("objectWrapper", objectWrapper);
        this.objectWrapper = objectWrapper;
        this.properties.setProperty(OBJECT_WRAPPER_KEY, objectWrapper.getClass().getName());
    }

    public ObjectWrapper getObjectWrapper() {
        return this.objectWrapper != null ? this.objectWrapper : this.parent.getObjectWrapper();
    }

    public void setOutputEncoding(String outputEncoding) {
        this.outputEncoding = outputEncoding;
        if (outputEncoding != null) {
            this.properties.setProperty(OUTPUT_ENCODING_KEY, outputEncoding);
        } else {
            this.properties.remove(OUTPUT_ENCODING_KEY);
        }
        this.outputEncodingSet = true;
    }

    public String getOutputEncoding() {
        return this.outputEncodingSet ? this.outputEncoding : (this.parent != null ? this.parent.getOutputEncoding() : null);
    }

    public void setURLEscapingCharset(String urlEscapingCharset) {
        this.urlEscapingCharset = urlEscapingCharset;
        if (urlEscapingCharset != null) {
            this.properties.setProperty(URL_ESCAPING_CHARSET_KEY, urlEscapingCharset);
        } else {
            this.properties.remove(URL_ESCAPING_CHARSET_KEY);
        }
        this.urlEscapingCharsetSet = true;
    }

    public String getURLEscapingCharset() {
        return this.urlEscapingCharsetSet ? this.urlEscapingCharset : (this.parent != null ? this.parent.getURLEscapingCharset() : null);
    }

    public void setNewBuiltinClassResolver(TemplateClassResolver newBuiltinClassResolver) {
        NullArgumentException.check("newBuiltinClassResolver", newBuiltinClassResolver);
        this.newBuiltinClassResolver = newBuiltinClassResolver;
        this.properties.setProperty(NEW_BUILTIN_CLASS_RESOLVER_KEY, newBuiltinClassResolver.getClass().getName());
    }

    public TemplateClassResolver getNewBuiltinClassResolver() {
        return this.newBuiltinClassResolver != null ? this.newBuiltinClassResolver : this.parent.getNewBuiltinClassResolver();
    }

    public void setAutoFlush(boolean autoFlush) {
        this.autoFlush = autoFlush;
        this.properties.setProperty(AUTO_FLUSH_KEY, String.valueOf(autoFlush));
    }

    public boolean getAutoFlush() {
        return this.autoFlush != null ? this.autoFlush : (this.parent != null ? this.parent.getAutoFlush() : true);
    }

    public void setShowErrorTips(boolean showTips) {
        this.showErrorTips = showTips;
        this.properties.setProperty(SHOW_ERROR_TIPS_KEY, String.valueOf(showTips));
    }

    public boolean getShowErrorTips() {
        return this.showErrorTips != null ? this.showErrorTips : (this.parent != null ? this.parent.getShowErrorTips() : true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setSetting(String name, String value) throws TemplateException {
        boolean unknown = false;
        try {
            if (LOCALE_KEY.equals(name)) {
                this.setLocale(StringUtil.deduceLocale(value));
            } else if (NUMBER_FORMAT_KEY.equals(name)) {
                this.setNumberFormat(value);
            } else if (TIME_FORMAT_KEY.equals(name)) {
                this.setTimeFormat(value);
            } else if (DATE_FORMAT_KEY.equals(name)) {
                this.setDateFormat(value);
            } else if (DATETIME_FORMAT_KEY.equals(name)) {
                this.setDateTimeFormat(value);
            } else if (TIME_ZONE_KEY.equals(name)) {
                this.setTimeZone(this.parseTimeZoneSettingValue(value));
            } else if (SQL_DATE_AND_TIME_TIME_ZONE_KEY.equals(name)) {
                this.setSQLDateAndTimeTimeZone(value.equals("null") ? null : this.parseTimeZoneSettingValue(value));
            } else if (CLASSIC_COMPATIBLE_KEY.equals(name)) {
                char firstChar = value != null && value.length() > 0 ? value.charAt(0) : (char)'\u0000';
                if (Character.isDigit(firstChar) || firstChar == '+' || firstChar == '-') {
                    this.setClassicCompatibleAsInt(Integer.parseInt(value));
                } else {
                    this.setClassicCompatible(value != null ? StringUtil.getYesNo(value) : false);
                }
            } else if (TEMPLATE_EXCEPTION_HANDLER_KEY.equals(name)) {
                if (value.indexOf(46) == -1) {
                    if ("debug".equalsIgnoreCase(value)) {
                        this.setTemplateExceptionHandler(TemplateExceptionHandler.DEBUG_HANDLER);
                    } else if ("html_debug".equalsIgnoreCase(value)) {
                        this.setTemplateExceptionHandler(TemplateExceptionHandler.HTML_DEBUG_HANDLER);
                    } else if ("ignore".equalsIgnoreCase(value)) {
                        this.setTemplateExceptionHandler(TemplateExceptionHandler.IGNORE_HANDLER);
                    } else {
                        if (!"rethrow".equalsIgnoreCase(value)) throw this.invalidSettingValueException(name, value);
                        this.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
                    }
                } else {
                    this.setTemplateExceptionHandler((TemplateExceptionHandler)_ObjectBuilderSettingEvaluator.eval(value, TemplateExceptionHandler.class, _SettingEvaluationEnvironment.getCurrent()));
                }
            } else if (ARITHMETIC_ENGINE_KEY.equals(name)) {
                if (value.indexOf(46) == -1) {
                    if ("bigdecimal".equalsIgnoreCase(value)) {
                        this.setArithmeticEngine(ArithmeticEngine.BIGDECIMAL_ENGINE);
                    } else {
                        if (!"conservative".equalsIgnoreCase(value)) throw this.invalidSettingValueException(name, value);
                        this.setArithmeticEngine(ArithmeticEngine.CONSERVATIVE_ENGINE);
                    }
                } else {
                    this.setArithmeticEngine((ArithmeticEngine)_ObjectBuilderSettingEvaluator.eval(value, ArithmeticEngine.class, _SettingEvaluationEnvironment.getCurrent()));
                }
            } else if (OBJECT_WRAPPER_KEY.equals(name)) {
                if (DEFAULT.equalsIgnoreCase(value)) {
                    this.setObjectWrapper(ObjectWrapper.DEFAULT_WRAPPER);
                } else if ("simple".equalsIgnoreCase(value)) {
                    this.setObjectWrapper(ObjectWrapper.SIMPLE_WRAPPER);
                } else if ("beans".equalsIgnoreCase(value)) {
                    this.setObjectWrapper(ObjectWrapper.BEANS_WRAPPER);
                } else if ("jython".equalsIgnoreCase(value)) {
                    Class<?> clazz = Class.forName("org.mapstruct.ap.shaded.freemarker.ext.jython.JythonWrapper");
                    this.setObjectWrapper((ObjectWrapper)clazz.getField("INSTANCE").get(null));
                } else {
                    this.setObjectWrapper((ObjectWrapper)_ObjectBuilderSettingEvaluator.eval(value, ObjectWrapper.class, _SettingEvaluationEnvironment.getCurrent()));
                }
            } else if (BOOLEAN_FORMAT_KEY.equals(name)) {
                this.setBooleanFormat(value);
            } else if (OUTPUT_ENCODING_KEY.equals(name)) {
                this.setOutputEncoding(value);
            } else if (URL_ESCAPING_CHARSET_KEY.equals(name)) {
                this.setURLEscapingCharset(value);
            } else if (STRICT_BEAN_MODELS.equals(name)) {
                this.setStrictBeanModels(StringUtil.getYesNo(value));
            } else if (AUTO_FLUSH_KEY.equals(name)) {
                this.setAutoFlush(StringUtil.getYesNo(value));
            } else if (SHOW_ERROR_TIPS_KEY.equals(name)) {
                this.setShowErrorTips(StringUtil.getYesNo(value));
            } else if (NEW_BUILTIN_CLASS_RESOLVER_KEY.equals(name)) {
                if ("unrestricted".equals(value)) {
                    this.setNewBuiltinClassResolver(TemplateClassResolver.UNRESTRICTED_RESOLVER);
                } else if ("safer".equals(value)) {
                    this.setNewBuiltinClassResolver(TemplateClassResolver.SAFER_RESOLVER);
                } else if ("allows_nothing".equals(value)) {
                    this.setNewBuiltinClassResolver(TemplateClassResolver.ALLOWS_NOTHING_RESOLVER);
                } else if (value.indexOf(":") != -1) {
                    ArrayList segments = this.parseAsSegmentedList(value);
                    HashSet allowedClasses = null;
                    List trustedTemplates = null;
                    for (int i = 0; i < segments.size(); ++i) {
                        KeyValuePair kv = (KeyValuePair)segments.get(i);
                        String segmentKey = (String)kv.getKey();
                        List segmentValue = (List)kv.getValue();
                        if (segmentKey.equals(ALLOWED_CLASSES)) {
                            allowedClasses = new HashSet(segmentValue);
                            continue;
                        }
                        if (!segmentKey.equals(TRUSTED_TEMPLATES)) throw new ParseException("Unrecognized list segment key: " + StringUtil.jQuote(segmentKey) + ". Supported keys are: \"" + ALLOWED_CLASSES + "\", \"" + TRUSTED_TEMPLATES + "\"", 0, 0);
                        trustedTemplates = segmentValue;
                    }
                    this.setNewBuiltinClassResolver(new OptInTemplateClassResolver(allowedClasses, trustedTemplates));
                } else {
                    if (value.indexOf(46) == -1) throw this.invalidSettingValueException(name, value);
                    this.setNewBuiltinClassResolver((TemplateClassResolver)_ObjectBuilderSettingEvaluator.eval(value, TemplateClassResolver.class, _SettingEvaluationEnvironment.getCurrent()));
                }
            } else {
                unknown = true;
            }
        }
        catch (Exception e) {
            throw this.settingValueAssignmentException(name, value, e);
        }
        if (!unknown) return;
        throw this.unknownSettingException(name);
    }

    private TimeZone parseTimeZoneSettingValue(String value) {
        TimeZone tz = JVM_DEFAULT.equalsIgnoreCase(value) ? TimeZone.getDefault() : TimeZone.getTimeZone(value);
        return tz;
    }

    public void setStrictBeanModels(boolean strict) {
        if (!(this.objectWrapper instanceof BeansWrapper)) {
            throw new IllegalStateException("The value of the object_wrapper setting isn't a " + BeansWrapper.class.getName() + ".");
        }
        ((BeansWrapper)this.objectWrapper).setStrict(strict);
    }

    public String getSetting(String key) {
        return this.properties.getProperty(key);
    }

    public Map getSettings() {
        return Collections.unmodifiableMap(this.properties);
    }

    protected Environment getEnvironment() {
        return this instanceof Environment ? (Environment)this : Environment.getCurrentEnvironment();
    }

    protected TemplateException unknownSettingException(String name) {
        return new UnknownSettingException(this.getEnvironment(), name, this.getCorrectedNameForUnknownSetting(name));
    }

    protected String getCorrectedNameForUnknownSetting(String name) {
        return null;
    }

    protected TemplateException settingValueAssignmentException(String name, String value, Throwable cause) {
        return new SettingValueAssignmentException(this.getEnvironment(), name, value, cause);
    }

    protected TemplateException invalidSettingValueException(String name, String value) {
        return new _MiscTemplateException(this.getEnvironment(), new Object[]{"Invalid value for setting ", new _DelayedJQuote(name), ": ", new _DelayedJQuote(value)});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSettings(Properties props) throws TemplateException {
        _SettingEvaluationEnvironment prevEnv = _SettingEvaluationEnvironment.startScope();
        try {
            Iterator<Object> it = props.keySet().iterator();
            while (it.hasNext()) {
                String key = (String)it.next();
                this.setSetting(key, props.getProperty(key).trim());
            }
        }
        finally {
            _SettingEvaluationEnvironment.endScope(prevEnv);
        }
    }

    public void setSettings(InputStream propsIn) throws TemplateException, IOException {
        Properties p = new Properties();
        p.load(propsIn);
        this.setSettings(p);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setCustomAttribute(Object key, Object value) {
        HashMap hashMap = this.customAttributes;
        synchronized (hashMap) {
            this.customAttributes.put(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object getCustomAttribute(Object key, CustomAttribute attr) {
        HashMap hashMap = this.customAttributes;
        synchronized (hashMap) {
            Object o = this.customAttributes.get(key);
            if (o == null && !this.customAttributes.containsKey(key)) {
                o = attr.create();
                this.customAttributes.put(key, o);
            }
            return o;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCustomAttribute(String name, Object value) {
        HashMap hashMap = this.customAttributes;
        synchronized (hashMap) {
            this.customAttributes.put(name, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getCustomAttributeNames() {
        HashMap hashMap = this.customAttributes;
        synchronized (hashMap) {
            LinkedList names = new LinkedList(this.customAttributes.keySet());
            Iterator iter = names.iterator();
            while (iter.hasNext()) {
                if (iter.next() instanceof String) continue;
                iter.remove();
            }
            return names.toArray(new String[names.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCustomAttribute(String name) {
        HashMap hashMap = this.customAttributes;
        synchronized (hashMap) {
            this.customAttributes.remove(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getCustomAttribute(String name) {
        Object retval;
        HashMap hashMap = this.customAttributes;
        synchronized (hashMap) {
            retval = this.customAttributes.get(name);
            if (retval == null && this.customAttributes.containsKey(name)) {
                return null;
            }
        }
        if (retval == null && this.parent != null) {
            return this.parent.getCustomAttribute(name);
        }
        return retval;
    }

    protected void doAutoImportsAndIncludes(Environment env) throws TemplateException, IOException {
        if (this.parent != null) {
            this.parent.doAutoImportsAndIncludes(env);
        }
    }

    protected ArrayList parseAsList(String text) throws ParseException {
        return new SettingStringParser(text).parseAsList();
    }

    protected ArrayList parseAsSegmentedList(String text) throws ParseException {
        return new SettingStringParser(text).parseAsSegmentedList();
    }

    protected HashMap parseAsImportList(String text) throws ParseException {
        return new SettingStringParser(text).parseAsImportList();
    }

    private static class SettingStringParser {
        private String text;
        private int p;
        private int ln;

        private SettingStringParser(String text) {
            this.text = text;
            this.p = 0;
            this.ln = text.length();
        }

        ArrayList parseAsSegmentedList() throws ParseException {
            char c;
            ArrayList<KeyValuePair> segments = new ArrayList<KeyValuePair>();
            ArrayList<String> currentSegment = null;
            while ((c = this.skipWS()) != ' ') {
                String item = this.fetchStringValue();
                c = this.skipWS();
                if (c == ':') {
                    currentSegment = new ArrayList<String>();
                    segments.add(new KeyValuePair(item, currentSegment));
                } else {
                    if (currentSegment == null) {
                        throw new ParseException("The very first list item must be followed by \":\" so it will be the key for the following sub-list.", 0, 0);
                    }
                    currentSegment.add(item);
                }
                if (c == ' ') break;
                if (c != ',' && c != ':') {
                    throw new ParseException("Expected \",\" or \":\" or the end of text but found \"" + c + "\"", 0, 0);
                }
                ++this.p;
            }
            return segments;
        }

        ArrayList parseAsList() throws ParseException {
            char c;
            ArrayList<String> seq = new ArrayList<String>();
            while ((c = this.skipWS()) != ' ') {
                seq.add(this.fetchStringValue());
                c = this.skipWS();
                if (c == ' ') break;
                if (c != ',') {
                    throw new ParseException("Expected \",\" or the end of text but found \"" + c + "\"", 0, 0);
                }
                ++this.p;
            }
            return seq;
        }

        HashMap parseAsImportList() throws ParseException {
            char c;
            HashMap<String, String> map = new HashMap<String, String>();
            while ((c = this.skipWS()) != ' ') {
                String lib = this.fetchStringValue();
                c = this.skipWS();
                if (c == ' ') {
                    throw new ParseException("Unexpected end of text: expected \"as\"", 0, 0);
                }
                String s2 = this.fetchKeyword();
                if (!s2.equalsIgnoreCase("as")) {
                    throw new ParseException("Expected \"as\", but found " + StringUtil.jQuote(s2), 0, 0);
                }
                c = this.skipWS();
                if (c == ' ') {
                    throw new ParseException("Unexpected end of text: expected gate hash name", 0, 0);
                }
                String ns = this.fetchStringValue();
                map.put(ns, lib);
                c = this.skipWS();
                if (c == ' ') break;
                if (c != ',') {
                    throw new ParseException("Expected \",\" or the end of text but found \"" + c + "\"", 0, 0);
                }
                ++this.p;
            }
            return map;
        }

        String fetchStringValue() throws ParseException {
            String w = this.fetchWord();
            if (w.startsWith("'") || w.startsWith("\"")) {
                w = w.substring(1, w.length() - 1);
            }
            return StringUtil.FTLStringLiteralDec(w);
        }

        String fetchKeyword() throws ParseException {
            String w = this.fetchWord();
            if (w.startsWith("'") || w.startsWith("\"")) {
                throw new ParseException("Keyword expected, but a string value found: " + w, 0, 0);
            }
            return w;
        }

        char skipWS() {
            while (this.p < this.ln) {
                char c = this.text.charAt(this.p);
                if (!Character.isWhitespace(c)) {
                    return c;
                }
                ++this.p;
            }
            return ' ';
        }

        private String fetchWord() throws ParseException {
            if (this.p == this.ln) {
                throw new ParseException("Unexpeced end of text", 0, 0);
            }
            char c = this.text.charAt(this.p);
            int b = this.p;
            if (c == '\'' || c == '\"') {
                boolean escaped = false;
                char q = c;
                ++this.p;
                while (this.p < this.ln) {
                    c = this.text.charAt(this.p);
                    if (!escaped) {
                        if (c == '\\') {
                            escaped = true;
                        } else if (c == q) {
                            break;
                        }
                    } else {
                        escaped = false;
                    }
                    ++this.p;
                }
                if (this.p == this.ln) {
                    throw new ParseException("Missing " + q, 0, 0);
                }
                ++this.p;
                return this.text.substring(b, this.p);
            }
            while (Character.isLetterOrDigit(c = this.text.charAt(this.p)) || c == '/' || c == '\\' || c == '_' || c == '.' || c == '-' || c == '!' || c == '*' || c == '?') {
                ++this.p;
                if (this.p < this.ln) continue;
            }
            if (b == this.p) {
                throw new ParseException("Unexpected character: " + c, 0, 0);
            }
            return this.text.substring(b, this.p);
        }
    }

    private static class KeyValuePair {
        private final Object key;
        private final Object value;

        KeyValuePair(Object key, Object value) {
            this.key = key;
            this.value = value;
        }

        Object getKey() {
            return this.key;
        }

        Object getValue() {
            return this.value;
        }
    }

    public static class SettingValueAssignmentException
    extends _MiscTemplateException {
        private SettingValueAssignmentException(Environment env, String name, String value, Throwable cause) {
            super(cause, env, new Object[]{"Failed to set setting ", new _DelayedJQuote(name), " to value ", new _DelayedJQuote(value), "; see cause exception."});
        }
    }

    public static class UnknownSettingException
    extends _MiscTemplateException {
        private UnknownSettingException(Environment env, String name, String correctedName) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "Unknown setting: ";
            objectArray2[1] = new _DelayedJQuote(name);
            if (correctedName == null) {
                objectArray = "";
            } else {
                Object[] objectArray3 = new Object[2];
                objectArray3[0] = ". You may meant: ";
                objectArray = objectArray3;
                objectArray3[1] = new _DelayedJQuote(correctedName);
            }
            objectArray2[2] = objectArray;
            super(env, objectArray2);
        }
    }
}

