/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.shaded.freemarker.core;

import java.io.StringReader;
import org.mapstruct.ap.shaded.freemarker.core.BuiltInForString;
import org.mapstruct.ap.shaded.freemarker.core.Environment;
import org.mapstruct.ap.shaded.freemarker.core.Expression;
import org.mapstruct.ap.shaded.freemarker.core.FMParser;
import org.mapstruct.ap.shaded.freemarker.core.FMParserTokenManager;
import org.mapstruct.ap.shaded.freemarker.core.NonNumericalException;
import org.mapstruct.ap.shaded.freemarker.core.ParseException;
import org.mapstruct.ap.shaded.freemarker.core.SimpleCharStream;
import org.mapstruct.ap.shaded.freemarker.core.TokenMgrError;
import org.mapstruct.ap.shaded.freemarker.core._DelayedGetMessage;
import org.mapstruct.ap.shaded.freemarker.core._DelayedGetMessageWithoutStackTop;
import org.mapstruct.ap.shaded.freemarker.core._DelayedJQuote;
import org.mapstruct.ap.shaded.freemarker.core._MiscTemplateException;
import org.mapstruct.ap.shaded.freemarker.template.SimpleNumber;
import org.mapstruct.ap.shaded.freemarker.template.TemplateBooleanModel;
import org.mapstruct.ap.shaded.freemarker.template.TemplateException;
import org.mapstruct.ap.shaded.freemarker.template.TemplateModel;
import org.mapstruct.ap.shaded.freemarker.template._TemplateAPI;

class BuiltInsForStringsMisc {
    private BuiltInsForStringsMisc() {
    }

    static class numberBI
    extends BuiltInForString {
        numberBI() {
        }

        TemplateModel calculateResult(String s2, Environment env) throws TemplateException {
            try {
                return new SimpleNumber(env.getArithmeticEngine().toNumber(s2));
            }
            catch (NumberFormatException nfe) {
                throw NonNumericalException.newMalformedNumberException(this, s2, env);
            }
        }
    }

    static class evalBI
    extends BuiltInForString {
        evalBI() {
        }

        TemplateModel calculateResult(String s2, Environment env) throws TemplateException {
            SimpleCharStream scs = new SimpleCharStream(new StringReader("(" + s2 + ")"), -1000000000, 1, s2.length() + 2);
            FMParserTokenManager token_source = new FMParserTokenManager(scs);
            token_source.incompatibleImprovements = _TemplateAPI.getTemplateLanguageVersionAsInt(this);
            token_source.SwitchTo(2);
            FMParser parser = new FMParser(token_source);
            parser.setTemplate(this.getTemplate());
            Expression exp = null;
            try {
                try {
                    exp = parser.Expression();
                }
                catch (TokenMgrError e) {
                    throw e.toParseException(this.getTemplate());
                }
            }
            catch (ParseException e) {
                throw new _MiscTemplateException((Expression)this, env, new Object[]{"Failed to \"?", this.key, "\" string with this error:\n\n", "---begin-message---\n", new _DelayedGetMessage(e), "\n---end-message---", "\n\nThe failing expression:"});
            }
            try {
                return exp.eval(env);
            }
            catch (TemplateException e) {
                throw new _MiscTemplateException((Expression)this, env, new Object[]{"Failed to \"?", this.key, "\" string with this error:\n\n", "---begin-message---\n", new _DelayedGetMessageWithoutStackTop(e), "\n---end-message---", "\n\nThe failing expression:"});
            }
        }
    }

    static class booleanBI
    extends BuiltInForString {
        booleanBI() {
        }

        TemplateModel calculateResult(String s2, Environment env) throws TemplateException {
            boolean b;
            if (s2.equals("true")) {
                b = true;
            } else if (s2.equals("false")) {
                b = false;
            } else if (s2.equals(env.getTrueStringValue())) {
                b = true;
            } else if (s2.equals(env.getFalseStringValue())) {
                b = false;
            } else {
                throw new _MiscTemplateException((Expression)this, env, new Object[]{"Can't convert this string to boolean: ", new _DelayedJQuote(s2)});
            }
            return b ? TemplateBooleanModel.TRUE : TemplateBooleanModel.FALSE;
        }
    }
}

