/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.shaded.freemarker.core;

import java.io.UnsupportedEncodingException;
import java.util.List;
import org.mapstruct.ap.shaded.freemarker.core.BuiltIn;
import org.mapstruct.ap.shaded.freemarker.core.BuiltInForString;
import org.mapstruct.ap.shaded.freemarker.core.Environment;
import org.mapstruct.ap.shaded.freemarker.core.ICIChainMember;
import org.mapstruct.ap.shaded.freemarker.core._TemplateModelException;
import org.mapstruct.ap.shaded.freemarker.template.SimpleScalar;
import org.mapstruct.ap.shaded.freemarker.template.TemplateMethodModel;
import org.mapstruct.ap.shaded.freemarker.template.TemplateModel;
import org.mapstruct.ap.shaded.freemarker.template.TemplateModelException;
import org.mapstruct.ap.shaded.freemarker.template.TemplateScalarModel;
import org.mapstruct.ap.shaded.freemarker.template._TemplateAPI;
import org.mapstruct.ap.shaded.freemarker.template.utility.StringUtil;

class BuiltInsForStringsEncoding {
    private BuiltInsForStringsEncoding() {
    }

    static abstract class AbstractUrlBIResult
    implements TemplateScalarModel,
    TemplateMethodModel {
        protected final BuiltIn parent;
        protected final String targetAsString;
        private final Environment env;
        private String cachedResult;

        protected AbstractUrlBIResult(BuiltIn parent, String target, Environment env) {
            this.parent = parent;
            this.targetAsString = target;
            this.env = env;
        }

        protected abstract String encodeWithCharset(String var1) throws UnsupportedEncodingException;

        public Object exec(List args) throws TemplateModelException {
            this.parent.checkMethodArgCount(args.size(), 1);
            try {
                return new SimpleScalar(this.encodeWithCharset((String)args.get(0)));
            }
            catch (UnsupportedEncodingException e) {
                throw new _TemplateModelException((Throwable)e, "Failed to execute URL encoding.");
            }
        }

        public String getAsString() throws TemplateModelException {
            if (this.cachedResult == null) {
                String cs = this.env.getEffectiveURLEscapingCharset();
                if (cs == null) {
                    throw new _TemplateModelException("To do URL encoding, the framework that encloses FreeMarker must specify the output encoding or the URL encoding charset, so ask the programmers to fix it. Or, as a last chance, you can set the url_encoding_charset setting in the template, e.g. <#setting url_escaping_charset='ISO-8859-1'>, or give the charset explicitly to the buit-in, e.g. foo?url('ISO-8859-1').");
                }
                try {
                    this.cachedResult = this.encodeWithCharset(cs);
                }
                catch (UnsupportedEncodingException e) {
                    throw new _TemplateModelException((Throwable)e, "Failed to execute URL encoding.");
                }
            }
            return this.cachedResult;
        }
    }

    static class xmlBI
    extends BuiltInForString {
        xmlBI() {
        }

        TemplateModel calculateResult(String s2, Environment env) {
            return new SimpleScalar(StringUtil.XMLEnc(s2));
        }
    }

    static class xhtmlBI
    extends BuiltInForString {
        xhtmlBI() {
        }

        TemplateModel calculateResult(String s2, Environment env) {
            return new SimpleScalar(StringUtil.XHTMLEnc(s2));
        }
    }

    static class urlPathBI
    extends BuiltInForString {
        urlPathBI() {
        }

        TemplateModel calculateResult(String s2, Environment env) {
            return new UrlPathBIResult(this, s2, env);
        }

        static class UrlPathBIResult
        extends AbstractUrlBIResult {
            protected UrlPathBIResult(BuiltIn parent, String target, Environment env) {
                super(parent, target, env);
            }

            protected String encodeWithCharset(String cs) throws UnsupportedEncodingException {
                return StringUtil.URLPathEnc(this.targetAsString, cs);
            }
        }
    }

    static class urlBI
    extends BuiltInForString {
        urlBI() {
        }

        TemplateModel calculateResult(String s2, Environment env) {
            return new UrlBIResult(this, s2, env);
        }

        static class UrlBIResult
        extends AbstractUrlBIResult {
            protected UrlBIResult(BuiltIn parent, String target, Environment env) {
                super(parent, target, env);
            }

            protected String encodeWithCharset(String cs) throws UnsupportedEncodingException {
                return StringUtil.URLEnc(this.targetAsString, cs);
            }
        }
    }

    static class rtfBI
    extends BuiltInForString {
        rtfBI() {
        }

        TemplateModel calculateResult(String s2, Environment env) {
            return new SimpleScalar(StringUtil.RTFEnc(s2));
        }
    }

    static class json_stringBI
    extends BuiltInForString {
        json_stringBI() {
        }

        TemplateModel calculateResult(String s2, Environment env) {
            return new SimpleScalar(StringUtil.jsonStringEnc(s2));
        }
    }

    static class js_stringBI
    extends BuiltInForString {
        js_stringBI() {
        }

        TemplateModel calculateResult(String s2, Environment env) {
            return new SimpleScalar(StringUtil.javaScriptStringEnc(s2));
        }
    }

    static class j_stringBI
    extends BuiltInForString {
        j_stringBI() {
        }

        TemplateModel calculateResult(String s2, Environment env) {
            return new SimpleScalar(StringUtil.javaStringEnc(s2));
        }
    }

    static class htmlBI
    extends BuiltInForString
    implements ICIChainMember {
        private final BIBeforeICI2d3d20 prevICIObj = new BIBeforeICI2d3d20();

        htmlBI() {
        }

        TemplateModel calculateResult(String s2, Environment env) {
            return new SimpleScalar(StringUtil.XHTMLEnc(s2));
        }

        public int getMinimumICIVersion() {
            return _TemplateAPI.VERSION_INT_2_3_20;
        }

        public Object getPreviousICIChainMember() {
            return this.prevICIObj;
        }

        static class BIBeforeICI2d3d20
        extends BuiltInForString {
            BIBeforeICI2d3d20() {
            }

            TemplateModel calculateResult(String s2, Environment env) {
                return new SimpleScalar(StringUtil.HTMLEnc(s2));
            }
        }
    }
}

