/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.util.workarounds;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.apt.dispatch.BaseProcessingEnvImpl;
import org.eclipse.jdt.internal.compiler.apt.model.ElementImpl;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

final class EclipseAsMemberOfWorkaround {
    private EclipseAsMemberOfWorkaround() {
    }

    static TypeMirror asMemberOf(ProcessingEnvironment environment2, DeclaredType containing, Element element) {
        ElementImpl elementImpl = EclipseAsMemberOfWorkaround.tryCast(element, ElementImpl.class);
        BaseProcessingEnvImpl env = EclipseAsMemberOfWorkaround.tryCast(environment2, BaseProcessingEnvImpl.class);
        if (elementImpl == null || env == null) {
            return null;
        }
        MethodBinding methodBinding = (MethodBinding)elementImpl._binding;
        ReferenceBinding referenceBinding = (ReferenceBinding)((ElementImpl)environment2.getTypeUtils().asElement((TypeMirror)containing))._binding;
        MethodBinding inSuperclassHiearchy = EclipseAsMemberOfWorkaround.findInSuperclassHierarchy(methodBinding, referenceBinding);
        if (inSuperclassHiearchy != null) {
            return env.getFactory().newTypeMirror((Binding)inSuperclassHiearchy);
        }
        ArrayList<MethodBinding> candidatesFromInterfaces = new ArrayList<MethodBinding>();
        EclipseAsMemberOfWorkaround.collectFromInterfaces(methodBinding, referenceBinding, new HashSet<ReferenceBinding>(), candidatesFromInterfaces);
        Collections.sort(candidatesFromInterfaces, MostSpecificMethodBindingComparator.INSTANCE);
        if (!candidatesFromInterfaces.isEmpty()) {
            return env.getFactory().newTypeMirror((Binding)candidatesFromInterfaces.get(0));
        }
        return null;
    }

    private static <T> T tryCast(Object instance, Class<T> type) {
        if (instance != null && type.isInstance(instance)) {
            return type.cast(instance);
        }
        return null;
    }

    private static void collectFromInterfaces(MethodBinding methodBinding, ReferenceBinding typeBinding, Set<ReferenceBinding> visitedTypes, List<MethodBinding> found) {
        if (typeBinding == null) {
            return;
        }
        EclipseAsMemberOfWorkaround.collectFromInterfaces(methodBinding, typeBinding.superclass(), visitedTypes, found);
        for (ReferenceBinding ifc : typeBinding.superInterfaces()) {
            if (visitedTypes.contains(ifc)) continue;
            visitedTypes.add(ifc);
            MethodBinding f = EclipseAsMemberOfWorkaround.findMatchingMethodBinding(methodBinding, ifc.methods());
            if (f == null) {
                EclipseAsMemberOfWorkaround.collectFromInterfaces(methodBinding, ifc, visitedTypes, found);
                continue;
            }
            found.add(f);
        }
    }

    private static MethodBinding findMatchingMethodBinding(MethodBinding baseMethod, MethodBinding[] methods) {
        for (MethodBinding method : methods) {
            if (!CharOperation.equals((char[])method.selector, (char[])baseMethod.selector) || method.original() != baseMethod && !method.areParameterErasuresEqual(baseMethod)) continue;
            return method;
        }
        return null;
    }

    private static MethodBinding findInSuperclassHierarchy(MethodBinding baseMethod, ReferenceBinding typeBinding) {
        while (typeBinding != null) {
            MethodBinding matching = EclipseAsMemberOfWorkaround.findMatchingMethodBinding(baseMethod, typeBinding.methods());
            if (matching != null) {
                return matching;
            }
            typeBinding = typeBinding.superclass();
        }
        return null;
    }

    private static final class MostSpecificMethodBindingComparator
    implements Comparator<MethodBinding> {
        private static final MostSpecificMethodBindingComparator INSTANCE = new MostSpecificMethodBindingComparator();

        private MostSpecificMethodBindingComparator() {
        }

        @Override
        public int compare(MethodBinding first, MethodBinding second) {
            boolean secondParamsAssignableFromFirst;
            boolean firstParamsAssignableFromSecond = first.areParametersCompatibleWith(second.parameters);
            if (firstParamsAssignableFromSecond != (secondParamsAssignableFromFirst = second.areParametersCompatibleWith(first.parameters))) {
                return firstParamsAssignableFromSecond ? 1 : -1;
            }
            if (TypeBinding.equalsEquals((TypeBinding)first.returnType, (TypeBinding)second.returnType)) {
                return 0;
            }
            boolean firstReturnTypeAssignableFromSecond = second.returnType.isCompatibleWith(first.returnType);
            return firstReturnTypeAssignableFromSecond ? 1 : -1;
        }
    }
}

