/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import org.mapstruct.ap.internal.prism.AfterMappingPrism;
import org.mapstruct.ap.internal.prism.BeforeMappingPrism;
import org.mapstruct.ap.internal.util.accessor.Accessor;
import org.mapstruct.ap.internal.util.accessor.ExecutableElementAccessor;
import org.mapstruct.ap.internal.util.accessor.VariableElementAccessor;
import org.mapstruct.ap.internal.util.workarounds.SpecificCompilerWorkarounds;
import org.mapstruct.ap.spi.TypeHierarchyErroneousException;

public class Executables {
    private static final Method DEFAULT_METHOD;

    private Executables() {
    }

    public static boolean isFieldAccessor(Accessor accessor) {
        ExecutableElement executable = accessor.getExecutable();
        return executable == null && Executables.isPublic(accessor) && Executables.isNotStatic(accessor);
    }

    static boolean isPublicNotStatic(Accessor accessor) {
        return Executables.isPublic(accessor) && Executables.isNotStatic(accessor);
    }

    static boolean isPublic(Accessor method) {
        return method.getModifiers().contains((Object)Modifier.PUBLIC);
    }

    private static boolean isNotStatic(Accessor accessor) {
        return !accessor.getModifiers().contains((Object)Modifier.STATIC);
    }

    public static boolean isFinal(Accessor accessor) {
        return accessor != null && accessor.getModifiers().contains((Object)Modifier.FINAL);
    }

    public static boolean isDefaultMethod(ExecutableElement method) {
        try {
            return DEFAULT_METHOD != null && Boolean.TRUE.equals(DEFAULT_METHOD.invoke((Object)method, new Object[0]));
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            return false;
        }
    }

    private static TypeElement asTypeElement(TypeMirror mirror) {
        return (TypeElement)((DeclaredType)mirror).asElement();
    }

    public static List<ExecutableElement> getAllEnclosedExecutableElements(Elements elementUtils, TypeElement element) {
        ArrayList<ExecutableElement> executables = new ArrayList<ExecutableElement>();
        for (Accessor accessor : Executables.getAllEnclosedAccessors(elementUtils, element)) {
            if (accessor.getExecutable() == null) continue;
            executables.add(accessor.getExecutable());
        }
        return executables;
    }

    public static List<Accessor> getAllEnclosedAccessors(Elements elementUtils, TypeElement element) {
        ArrayList<Accessor> enclosedElements = new ArrayList<Accessor>();
        element = SpecificCompilerWorkarounds.replaceTypeElementIfNecessary(elementUtils, element);
        Executables.addEnclosedElementsInHierarchy(elementUtils, enclosedElements, element, element);
        return enclosedElements;
    }

    private static void addEnclosedElementsInHierarchy(Elements elementUtils, List<Accessor> alreadyAdded, TypeElement element, TypeElement parentType) {
        if (element != parentType) {
            element = SpecificCompilerWorkarounds.replaceTypeElementIfNecessary(elementUtils, element);
        }
        if (element.asType().getKind() == TypeKind.ERROR) {
            throw new TypeHierarchyErroneousException(element);
        }
        Executables.addNotYetOverridden(elementUtils, alreadyAdded, ElementFilter.methodsIn(element.getEnclosedElements()), parentType);
        Executables.addFields(alreadyAdded, ElementFilter.fieldsIn(element.getEnclosedElements()));
        if (Executables.hasNonObjectSuperclass(element)) {
            Executables.addEnclosedElementsInHierarchy(elementUtils, alreadyAdded, Executables.asTypeElement(element.getSuperclass()), parentType);
        }
        for (TypeMirror typeMirror : element.getInterfaces()) {
            Executables.addEnclosedElementsInHierarchy(elementUtils, alreadyAdded, Executables.asTypeElement(typeMirror), parentType);
        }
    }

    private static void addNotYetOverridden(Elements elementUtils, List<Accessor> alreadyCollected, List<ExecutableElement> methodsToAdd, TypeElement parentType) {
        ArrayList<ExecutableElementAccessor> safeToAdd = new ArrayList<ExecutableElementAccessor>(methodsToAdd.size());
        for (ExecutableElement toAdd : methodsToAdd) {
            if (!Executables.isNotObjectEquals(toAdd) || !Executables.wasNotYetOverridden(elementUtils, alreadyCollected, toAdd, parentType)) continue;
            safeToAdd.add(new ExecutableElementAccessor(toAdd));
        }
        alreadyCollected.addAll(0, safeToAdd);
    }

    private static void addFields(List<Accessor> alreadyCollected, List<VariableElement> variablesToAdd) {
        ArrayList<VariableElementAccessor> safeToAdd = new ArrayList<VariableElementAccessor>(variablesToAdd.size());
        for (VariableElement toAdd : variablesToAdd) {
            safeToAdd.add(new VariableElementAccessor(toAdd));
        }
        alreadyCollected.addAll(0, safeToAdd);
    }

    private static boolean isNotObjectEquals(ExecutableElement executable) {
        return !executable.getSimpleName().contentEquals("equals") || executable.getParameters().size() != 1 || !Executables.asTypeElement(executable.getParameters().get(0).asType()).getQualifiedName().contentEquals("java.lang.Object");
    }

    private static boolean wasNotYetOverridden(Elements elementUtils, List<Accessor> alreadyCollected, ExecutableElement executable, TypeElement parentType) {
        ListIterator<Accessor> it = alreadyCollected.listIterator();
        while (it.hasNext()) {
            ExecutableElement executableInSubtype = it.next().getExecutable();
            if (executableInSubtype == null) continue;
            if (elementUtils.overrides(executableInSubtype, executable, parentType)) {
                return false;
            }
            if (!elementUtils.overrides(executable, executableInSubtype, parentType)) continue;
            it.remove();
            return true;
        }
        return true;
    }

    private static boolean hasNonObjectSuperclass(TypeElement element) {
        if (element.getSuperclass().getKind() == TypeKind.ERROR) {
            throw new TypeHierarchyErroneousException(element);
        }
        return element.getSuperclass().getKind() == TypeKind.DECLARED && !Executables.asTypeElement(element.getSuperclass()).getQualifiedName().toString().equals("java.lang.Object");
    }

    public static boolean isLifecycleCallbackMethod(ExecutableElement executableElement) {
        return Executables.isBeforeMappingMethod(executableElement) || Executables.isAfterMappingMethod(executableElement);
    }

    public static boolean isAfterMappingMethod(ExecutableElement executableElement) {
        return AfterMappingPrism.getInstanceOn(executableElement) != null;
    }

    public static boolean isBeforeMappingMethod(ExecutableElement executableElement) {
        return BeforeMappingPrism.getInstanceOn(executableElement) != null;
    }

    static {
        Method method;
        try {
            method = ExecutableElement.class.getMethod("isDefault", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            method = null;
        }
        DEFAULT_METHOD = method;
    }
}

