/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.model.common;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import org.mapstruct.ap.internal.model.common.Assignment;
import org.mapstruct.ap.internal.model.common.ModelElement;
import org.mapstruct.ap.internal.model.common.Type;
import org.mapstruct.ap.internal.util.Collections;
import org.mapstruct.ap.internal.util.Strings;

public class SourceRHS
extends ModelElement
implements Assignment {
    private final String sourceReference;
    private final Type sourceType;
    private String sourceLocalVarName;
    private String sourceLoopVarName;
    private final Set<String> existingVariableNames;
    private final String sourceErrorMessagePart;
    private final String sourcePresenceCheckerReference;
    private boolean useElementAsSourceTypeForMatching = false;
    private final String sourceParameterName;

    public SourceRHS(String sourceReference, Type sourceType, Set<String> existingVariableNames, String sourceErrorMessagePart) {
        this(sourceReference, sourceReference, null, sourceType, existingVariableNames, sourceErrorMessagePart);
    }

    public SourceRHS(String sourceParameterName, String sourceReference, String sourcePresenceCheckerReference, Type sourceType, Set<String> existingVariableNames, String sourceErrorMessagePart) {
        this.sourceReference = sourceReference;
        this.sourceType = sourceType;
        this.existingVariableNames = existingVariableNames;
        this.sourceErrorMessagePart = sourceErrorMessagePart;
        this.sourcePresenceCheckerReference = sourcePresenceCheckerReference;
        this.sourceParameterName = sourceParameterName;
    }

    @Override
    public String getSourceReference() {
        return this.sourceReference;
    }

    @Override
    public boolean isSourceReferenceParameter() {
        return this.sourceReference.equals(this.sourceParameterName);
    }

    @Override
    public String getSourcePresenceCheckerReference() {
        return this.sourcePresenceCheckerReference;
    }

    @Override
    public Type getSourceType() {
        return this.sourceType;
    }

    @Override
    public String createUniqueVarName(String desiredName) {
        String result = Strings.getSafeVariableName(desiredName, this.existingVariableNames);
        this.existingVariableNames.add(result);
        return result;
    }

    @Override
    public String getSourceLocalVarName() {
        return this.sourceLocalVarName;
    }

    @Override
    public void setSourceLocalVarName(String sourceLocalVarName) {
        this.sourceLocalVarName = sourceLocalVarName;
    }

    @Override
    public String getSourceLoopVarName() {
        return this.sourceLoopVarName;
    }

    @Override
    public void setSourceLoopVarName(String sourceLoopVarName) {
        this.sourceLoopVarName = sourceLoopVarName;
    }

    @Override
    public Set<Type> getImportTypes() {
        return java.util.Collections.emptySet();
    }

    @Override
    public List<Type> getThrownTypes() {
        return java.util.Collections.emptyList();
    }

    @Override
    public void setAssignment(Assignment assignment) {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public Assignment.AssignmentType getType() {
        return Assignment.AssignmentType.DIRECT;
    }

    @Override
    public boolean isCallingUpdateMethod() {
        return false;
    }

    public String toString() {
        return this.sourceReference;
    }

    public String getSourceErrorMessagePart() {
        return this.sourceErrorMessagePart;
    }

    public Type getSourceTypeForMatching() {
        if (this.useElementAsSourceTypeForMatching) {
            if (this.sourceType.isCollectionType()) {
                return Collections.first(this.sourceType.determineTypeArguments(Collection.class));
            }
            if (this.sourceType.isStreamType()) {
                return Collections.first(this.sourceType.determineTypeArguments(Stream.class));
            }
        }
        return this.sourceType;
    }

    public void setUseElementAsSourceTypeForMatching(boolean useElementAsSourceTypeForMatching) {
        this.useElementAsSourceTypeForMatching = useElementAsSourceTypeForMatching;
    }

    @Override
    public String getSourceParameterName() {
        return this.sourceParameterName;
    }
}

