/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.async.methods;

import org.apache.hc.core5.concurrent.FutureCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IgnoreCompleteExceptonFutureCallback<T>
implements FutureCallback<T> {
    private final FutureCallback<T> callback;
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public IgnoreCompleteExceptonFutureCallback(FutureCallback<T> callback) {
        this.callback = callback;
    }

    @Override
    public void completed(T result) {
        if (this.callback != null) {
            try {
                this.callback.completed(result);
            }
            catch (Exception ex) {
                this.log.error(ex.getMessage(), ex);
            }
        }
    }

    @Override
    public void failed(Exception ex) {
        if (this.callback != null) {
            this.callback.failed(ex);
        }
    }

    @Override
    public void cancelled() {
        if (this.callback != null) {
            this.callback.cancelled();
        }
    }
}

