/*
 * Decompiled with CFR 0.152.
 */
package io.tesla.proviso.archive.tar;

import com.google.common.io.ByteStreams;
import com.google.common.io.Closer;
import io.tesla.proviso.archive.ArchiverHelper;
import io.tesla.proviso.archive.Entry;
import io.tesla.proviso.archive.Source;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;

public class TarGzArchiveSource
implements Source {
    private final ArchiveInputStream archiveInputStream;
    private final Closer closer = Closer.create();

    public TarGzArchiveSource(File archive) {
        try {
            this.archiveInputStream = this.closer.register(ArchiverHelper.getArchiveHandler(archive).getInputStream());
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Cannot determine the type of archive %s.", archive), e);
        }
    }

    @Override
    public Iterable<Entry> entries() {
        return new Iterable<Entry>(){

            @Override
            public Iterator<Entry> iterator() {
                return new ArchiveEntryIterator();
            }
        };
    }

    @Override
    public void close() throws IOException {
        this.closer.close();
    }

    @Override
    public boolean isDirectory() {
        return true;
    }

    class ArchiveEntryIterator
    implements Iterator<Entry> {
        TarArchiveEntry archiveEntry;

        ArchiveEntryIterator() {
        }

        @Override
        public Entry next() {
            return new EntrySourceArchiveEntry(this.archiveEntry);
        }

        @Override
        public boolean hasNext() {
            try {
                this.archiveEntry = (TarArchiveEntry)TarGzArchiveSource.this.archiveInputStream.getNextEntry();
                return this.archiveEntry != null;
            }
            catch (IOException iOException) {
                return false;
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove method not implemented");
        }
    }

    class EntrySourceArchiveEntry
    implements Entry {
        final TarArchiveEntry archiveEntry;

        public EntrySourceArchiveEntry(TarArchiveEntry archiveEntry) {
            this.archiveEntry = archiveEntry;
        }

        @Override
        public String getName() {
            return this.archiveEntry.getName();
        }

        @Override
        public InputStream getInputStream() throws IOException {
            return TarGzArchiveSource.this.archiveInputStream;
        }

        @Override
        public long getSize() {
            return this.archiveEntry.getSize();
        }

        @Override
        public void writeEntry(OutputStream outputStream) throws IOException {
            ByteStreams.copy(this.getInputStream(), outputStream);
        }

        @Override
        public int getFileMode() {
            return this.archiveEntry.getMode();
        }

        @Override
        public boolean isDirectory() {
            return this.archiveEntry.isDirectory();
        }

        @Override
        public boolean isExecutable() {
            return false;
        }
    }
}

