/*
 * Decompiled with CFR 0.152.
 */
package io.tesla.proviso.archive;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import io.tesla.proviso.archive.ArchiveHandler;
import io.tesla.proviso.archive.ArchiverHelper;
import io.tesla.proviso.archive.Entry;
import io.tesla.proviso.archive.ExtendedArchiveEntry;
import io.tesla.proviso.archive.Source;
import io.tesla.proviso.archive.source.DirectoryEntry;
import io.tesla.proviso.archive.source.DirectorySource;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.codehaus.plexus.util.SelectorUtils;

public class Archiver {
    private final List<String> includes;
    private final List<String> excludes;
    private final List<String> executables;
    private final boolean useRoot;
    private final boolean flatten;

    private Archiver(List<String> includes, List<String> excludes, List<String> executables, boolean useRoot, boolean flatten) {
        this.includes = includes;
        this.excludes = excludes;
        this.executables = executables;
        this.useRoot = useRoot;
        this.flatten = flatten;
    }

    public void archive(File archive, List<String> sourceDirectories) throws IOException {
        File[] fileSourceDirectories = new File[sourceDirectories.size()];
        int i = 0;
        while (i < sourceDirectories.size()) {
            fileSourceDirectories[i] = new File(sourceDirectories.get(i));
            ++i;
        }
        this.archive(archive, fileSourceDirectories);
    }

    public void archive(File archive, File ... sourceDirectories) throws IOException {
        this.archive(archive, new DirectorySource(sourceDirectories));
    }

    public void archive(File archive, Source ... sources) throws IOException {
        ArchiveHandler archiveHandler = ArchiverHelper.getArchiveHandler(archive);
        Throwable throwable = null;
        Object var5_6 = null;
        try (ArchiveOutputStream aos = archiveHandler.getOutputStream();){
            HashMap<String, Boolean> paths = new HashMap<String, Boolean>();
            Source[] sourceArray = sources;
            int n = sources.length;
            int n2 = 0;
            while (n2 < n) {
                Source source = sourceArray[n2];
                for (Entry entry : source.entries()) {
                    String entryName = entry.getName();
                    boolean exclude = false;
                    if (!this.excludes.isEmpty()) {
                        for (String excludePattern : this.excludes) {
                            if (!SelectorUtils.match(excludePattern, entryName)) continue;
                            exclude = true;
                            break;
                        }
                    }
                    if (exclude) continue;
                    boolean include = true;
                    if (!this.includes.isEmpty()) {
                        for (String includePattern : this.includes) {
                            if (SelectorUtils.match(includePattern, entryName)) continue;
                            include = false;
                            break;
                        }
                    }
                    if (!include) continue;
                    if (!this.useRoot && source.isDirectory()) {
                        entryName = entryName.substring(entryName.indexOf(47) + 1);
                    }
                    if (this.flatten && source.isDirectory()) {
                        if (entry.isDirectory()) continue;
                        entryName = entryName.substring(entryName.lastIndexOf(47) + 1);
                    }
                    boolean isExecutable = false;
                    for (String executable : this.executables) {
                        if (!SelectorUtils.match(executable, entry.getName())) continue;
                        isExecutable = true;
                        break;
                    }
                    if (entry.isDirectory() && !entryName.endsWith("/")) {
                        entryName = String.valueOf(entryName) + "/";
                    }
                    for (String directoryName : this.getParentDirectoryNames(entryName)) {
                        if (paths.containsKey(directoryName)) continue;
                        paths.put(directoryName, Boolean.FALSE);
                        ExtendedArchiveEntry directoryEntry = archiveHandler.createEntryFor(directoryName, new DirectoryEntry(directoryName), false);
                        aos.putArchiveEntry(directoryEntry);
                        aos.closeArchiveEntry();
                    }
                    if (!paths.containsKey(entryName)) {
                        paths.put(entryName, Boolean.TRUE);
                        ExtendedArchiveEntry archiveEntry = archiveHandler.createEntryFor(entryName, entry, isExecutable);
                        aos.putArchiveEntry(archiveEntry);
                        entry.writeEntry(aos);
                        aos.closeArchiveEntry();
                        continue;
                    }
                    if (!Boolean.TRUE.equals(paths.get(entryName))) continue;
                    throw new IllegalArgumentException("Duplicate archive entry " + entryName);
                }
                source.close();
                ++n2;
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private Iterable<String> getParentDirectoryNames(String entryName) {
        ArrayList<String> directoryNames = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(entryName, "/");
        if (st.hasMoreTokens()) {
            StringBuilder directoryName = new StringBuilder(st.nextToken());
            while (st.hasMoreTokens()) {
                directoryName.append('/');
                directoryNames.add(directoryName.toString());
                directoryName.append(st.nextToken());
            }
        }
        return directoryNames;
    }

    public static ArchiverBuilder builder() {
        return new ArchiverBuilder();
    }

    /* synthetic */ Archiver(List list, List list2, List list3, boolean bl, boolean bl2, Archiver archiver) {
        this(list, list2, list3, bl, bl2);
    }

    public static class ArchiverBuilder {
        private List<String> includes = Lists.newArrayList();
        private List<String> excludes = Lists.newArrayList();
        private List<String> executables = Lists.newArrayList();
        private boolean useRoot = true;
        private boolean flatten = false;

        public ArchiverBuilder includes(String ... includes) {
            return this.includes(ImmutableList.copyOf(includes));
        }

        public ArchiverBuilder includes(Iterable<String> includes) {
            Iterables.addAll(this.includes, includes);
            return this;
        }

        public ArchiverBuilder excludes(String ... excludes) {
            return this.excludes(ImmutableList.copyOf(excludes));
        }

        public ArchiverBuilder excludes(Iterable<String> excludes) {
            Iterables.addAll(this.excludes, excludes);
            return this;
        }

        public ArchiverBuilder useRoot(boolean useRoot) {
            this.useRoot = useRoot;
            return this;
        }

        public Archiver build() {
            return new Archiver(this.includes, this.excludes, this.executables, this.useRoot, this.flatten, null);
        }

        public ArchiverBuilder executable(String ... executables) {
            return this.executable(ImmutableList.copyOf(executables));
        }

        public ArchiverBuilder executable(Iterable<String> executables) {
            Iterables.addAll(this.executables, executables);
            return this;
        }

        public ArchiverBuilder flatten(boolean flatten) {
            this.flatten = flatten;
            return this;
        }
    }
}

