/*
 * Decompiled with CFR 0.152.
 */
package io.sitoolkit.wt.util.infra.util;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class SystemUtils {
    private static boolean windows;
    private static boolean osx;

    public static boolean isWindows() {
        return windows;
    }

    public static boolean isOsX() {
        return osx;
    }

    public static List<String> getBrowsers() {
        ArrayList<String> browsers = new ArrayList<String>();
        browsers.add("chrome");
        browsers.add("firefox");
        if (SystemUtils.isWindows()) {
            browsers.add("ie");
            browsers.add("edge");
        }
        if (SystemUtils.isOsX()) {
            browsers.add("ios");
        }
        browsers.add("android");
        browsers.add("remote");
        return browsers;
    }

    public static File getSitRepository() {
        File repo;
        File file = repo = SystemUtils.isWindows() ? new File(System.getenv("ProgramData"), "sitoolkit/repository") : new File(System.getProperty("user.home"), ".sitoolkit/repository");
        if (!repo.exists()) {
            repo.mkdirs();
        }
        return repo;
    }

    public static String getEnvironmentInfo() {
        String info = Stream.of("java.version", "java.vendor", "os.name", "os.arch", "os.version").map(key -> String.format("%s=%s", key, System.getProperty(key))).collect(Collectors.joining(", "));
        return info;
    }

    static {
        String osName = System.getProperty("os.name");
        windows = osName.startsWith("Windows");
        osx = osName.startsWith("Mac");
    }
}

