/*
 * Decompiled with CFR 0.152.
 */
package io.sitoolkit.wt.util.infra.util;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import javafx.application.Platform;
import javafx.scene.control.ChoiceDialog;

public class OverwriteChecker {
    private Writable allWritable = Writable.NA;
    private boolean rebuild;

    public boolean isWritable(Path path) {
        if (!Files.exists(path, new LinkOption[0])) {
            return true;
        }
        if (this.rebuild) {
            return true;
        }
        if (Writable.No.equals((Object)this.allWritable)) {
            return false;
        }
        if (Writable.Yes.equals((Object)this.allWritable)) {
            return true;
        }
        Answer answer = this.confirmOverwriteInFxApplicationThread(path);
        this.allWritable = answer.allWritable;
        return Writable.Yes.equals((Object)answer.writable);
    }

    private Answer confirmOverwriteInFxApplicationThread(Path path) {
        if (Platform.isFxApplicationThread()) {
            return this.confirmOverwrite(path);
        }
        FutureTask<Answer> task = new FutureTask<Answer>(() -> this.confirmOverwrite(path));
        Platform.runLater(task);
        try {
            return task.get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    private Answer confirmOverwrite(Path path) {
        ChoiceDialog<Answer> choice = new ChoiceDialog<Answer>(Answer.n, Answer.values());
        choice.setHeaderText("SIToolkit \u30d5\u30a1\u30a4\u30eb\u4e0a\u66f8\u304d\u78ba\u8a8d");
        choice.setContentText("\u66f8\u8fbc\u307f\u5148\u306b\u30d5\u30a1\u30a4\u30eb\u304c\u5b58\u5728\u3057\u307e\u3059\u3002\n" + path.toAbsolutePath());
        return choice.showAndWait().orElse(Answer.n);
    }

    public boolean isRebuild() {
        return this.rebuild;
    }

    public void setRebuild(boolean rebuild) {
        this.rebuild = rebuild;
    }

    static enum Answer {
        y("\u4e0a\u66f8\u304d", Writable.Yes, Writable.NA),
        a("\u4ee5\u964d\u5168\u3066\u4e0a\u66f8\u304d", Writable.Yes, Writable.Yes),
        n("\u4e0a\u66f8\u304d\u3057\u306a\u3044", Writable.No, Writable.NA),
        q("\u4ee5\u964d\u5168\u3066\u4e0a\u66f8\u304d\u3057\u306a\u3044", Writable.No, Writable.NA);

        final String description;
        final Writable writable;
        final Writable allWritable;

        private Answer(String description, Writable writable, Writable allWritable) {
            this.description = description;
            this.writable = writable;
            this.allWritable = allWritable;
        }

        public String toString() {
            return this.description;
        }
    }

    static enum Writable {
        Yes,
        No,
        NA;

    }
}

