/*
 * Decompiled with CFR 0.152.
 */
package io.sitoolkit.wt.infra.selenium;

import io.sitoolkit.wt.infra.log.SitLogger;
import io.sitoolkit.wt.infra.log.SitLoggerFactory;
import io.sitoolkit.wt.infra.resource.MessageManager;
import io.sitoolkit.wt.infra.selenium.WebElementExceptionChecker;
import java.lang.reflect.InvocationTargetException;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.openqa.selenium.WebDriver;

public class WebElementMethodInterceptor
implements MethodInterceptor {
    private static final SitLogger LOG = SitLoggerFactory.getLogger(WebElementMethodInterceptor.class);
    private MethodInvocation webDriverFindElementInvocation;
    private Object webElement = null;
    private WebElementExceptionChecker checker;

    public WebElementMethodInterceptor(MethodInvocation webDriverFindElementInvocation, WebElementExceptionChecker checker) {
        this.check(webDriverFindElementInvocation);
        this.webDriverFindElementInvocation = webDriverFindElementInvocation;
        this.checker = checker;
    }

    @Override
    public Object invoke(MethodInvocation invocation) throws Throwable {
        String className = invocation.getThis().getClass().getName();
        String methodName = invocation.getMethod().getName();
        LOG.trace("invoke.method", className, methodName);
        try {
            if (this.webElement == null) {
                return invocation.proceed();
            }
            return this.invoke(invocation, this.webElement);
        }
        catch (Throwable t) {
            Throwable thr = t instanceof InvocationTargetException ? t.getCause() : t;
            LOG.trace("invoke.error", className, methodName, thr.getClass());
            if (this.checker.isRetriable(thr)) {
                LOG.trace("reinvoke.method", className, methodName);
                this.webElement = this.webDriverFindElementInvocation.proceed();
                return this.invoke(invocation, this.webElement);
            }
            throw thr;
        }
    }

    private Object invoke(MethodInvocation invocation, Object webElement) throws Throwable {
        return invocation.getMethod().invoke(webElement, invocation.getArguments());
    }

    private void check(MethodInvocation invocation) {
        if (!(invocation.getThis() instanceof WebDriver)) {
            throw new IllegalArgumentException(MessageManager.getMessage("object.model.error", invocation));
        }
        String methodName = invocation.getMethod().getName();
        if (!"findElement".equals(methodName)) {
            throw new IllegalArgumentException(MessageManager.getMessage("method.name.error", invocation));
        }
    }
}

