/*
 * Decompiled with CFR 0.152.
 */
package io.sitoolkit.wt.infra.selenium;

import io.sitoolkit.wt.infra.log.SitLogger;
import io.sitoolkit.wt.infra.log.SitLoggerFactory;
import io.sitoolkit.wt.infra.selenium.WebElementExceptionChecker;
import io.sitoolkit.wt.infra.selenium.WebElementMethodInterceptor;
import java.lang.reflect.Method;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.aop.framework.ProxyFactory;

public class WebDriverMethodInterceptor
implements MethodInterceptor {
    private static final SitLogger LOG = SitLoggerFactory.getLogger(WebDriverMethodInterceptor.class);
    private WebElementExceptionChecker checker;

    public WebDriverMethodInterceptor(WebElementExceptionChecker checker) {
        this.checker = checker;
    }

    @Override
    public Object invoke(MethodInvocation mi) throws Throwable {
        Method method = mi.getMethod();
        if (!"findElement".equals(method.getName())) {
            return mi.proceed();
        }
        Object ret = mi.proceed();
        if (ret == null) {
            LOG.debug("restart", mi.getThis().getClass().getName(), method.getName());
            ret = mi.proceed();
        }
        ProxyFactory proxyFactory = new ProxyFactory();
        proxyFactory.setTargetClass(ret.getClass());
        proxyFactory.addAdvice(new WebElementMethodInterceptor(mi, this.checker));
        proxyFactory.setTarget(ret);
        return proxyFactory.getProxy();
    }
}

