/*
 * Decompiled with CFR 0.152.
 */
package io.sitoolkit.wt.infra.selenium;

import io.sitoolkit.util.buildtoolhelper.proxysetting.ProxySettingService;
import io.sitoolkit.wt.infra.ConfigurationException;
import io.sitoolkit.wt.infra.PropertyUtils;
import io.sitoolkit.wt.infra.SitRepository;
import io.sitoolkit.wt.infra.log.SitLogger;
import io.sitoolkit.wt.infra.log.SitLoggerFactory;
import io.sitoolkit.wt.infra.process.ProcessUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.Enumeration;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.JOptionPane;
import lombok.Generated;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;

public class WebDriverInstaller {
    private static SitLogger LOG = SitLoggerFactory.getLogger(WebDriverInstaller.class);
    private WebDriverBinaryInfo winGeckoBinaryInfo = new WebDriverBinaryInfo("win", "gecko");
    private WebDriverBinaryInfo macGeckoBinaryInfo = new WebDriverBinaryInfo("mac", "gecko");
    private WebDriverBinaryInfo winChromeBinaryInfo = new WebDriverBinaryInfo("win", "chrome");
    private WebDriverBinaryInfo macChromeBinaryInfo = new WebDriverBinaryInfo("mac", "chrome");
    private WebDriverBinaryInfo ieBinaryInfo = new WebDriverBinaryInfo("ie");
    private WebDriverBinaryInfo edgeBinaryInfo = new WebDriverBinaryInfo("edge");
    private WebDriverBinaryInfo safariBinaryInfo = new WebDriverBinaryInfo("safari");
    private static final WebDriverInstaller instance = new WebDriverInstaller();

    private WebDriverInstaller() {
        Map<String, String> prop = PropertyUtils.loadAsMap("/webdriver-default.properties", false);
        prop.putAll(PropertyUtils.loadAsMap("/webdriver.properties", true));
        this.setProperties(prop, this.winGeckoBinaryInfo);
        this.setProperties(prop, this.macGeckoBinaryInfo);
        this.setProperties(prop, this.winChromeBinaryInfo);
        this.setProperties(prop, this.macChromeBinaryInfo);
        this.setProperties(prop, this.ieBinaryInfo);
        this.setProperties(prop, this.edgeBinaryInfo);
        this.setProperties(prop, this.safariBinaryInfo);
    }

    private void setProperties(Map<String, String> prop, WebDriverBinaryInfo binaryInfo) {
        String os = binaryInfo.os == null ? "" : binaryInfo.os + ".";
        binaryInfo.downloadUrl = prop.get(os + binaryInfo.driver + ".downloadUrl");
        binaryInfo.zipEntry = prop.get(os + binaryInfo.driver + ".zipEntry");
        binaryInfo.installFile = prop.get(os + binaryInfo.driver + ".installFile");
        String installDir = prop.get(os + binaryInfo.driver + ".installDir");
        if (StringUtils.isNotEmpty(installDir)) {
            binaryInfo.installDir = installDir;
        }
    }

    public String installGeckoDriver() {
        if (SystemUtils.IS_OS_WINDOWS) {
            return this.install(this.winGeckoBinaryInfo);
        }
        if (SystemUtils.IS_OS_MAC) {
            return this.install(this.macGeckoBinaryInfo);
        }
        return "";
    }

    public String installEdgeDriver() {
        return this.install(this.edgeBinaryInfo);
    }

    public String installChromeDriver() {
        if (SystemUtils.IS_OS_WINDOWS) {
            return this.install(this.winChromeBinaryInfo);
        }
        return this.install(this.macChromeBinaryInfo);
    }

    public String installIeDriver() {
        return this.install(this.ieBinaryInfo);
    }

    public void installSafariDriver() {
        File installFile = new File(this.safariBinaryInfo.installDir, this.safariBinaryInfo.installFile);
        try {
            if (!installFile.exists()) {
                ProxySettingService.getInstance().loadProxy();
                URL downloadUrl = new URL(this.safariBinaryInfo.downloadUrl);
                LOG.info("safari.dawnload", downloadUrl, installFile.getAbsolutePath());
                FileUtils.copyURLToFile(downloadUrl, installFile);
            }
            LOG.info("safari.install", installFile.getAbsolutePath());
            String script = IOUtils.toString(ClassLoader.getSystemResource("install-safaridriver.scpt"), "UTF-8");
            ProcessUtils.exec("osascript", "-e", script, installFile.getAbsolutePath());
            JOptionPane.showMessageDialog(null, "Safari\u3067\u6a5f\u80fd\u62e1\u5f35\"WebDriver\"\u3092\u30a4\u30f3\u30b9\u30c8\u30fc\u30eb\u3057\u305f\u3089OK\u30dc\u30bf\u30f3\u3092\u30af\u30ea\u30c3\u30af\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
            script = IOUtils.toString(ClassLoader.getSystemResource("quit-safari.scpt"), "UTF-8");
            ProcessUtils.exec("osascript", "-e", script, installFile.getAbsolutePath());
        }
        catch (IOException e) {
            throw new ConfigurationException(e);
        }
        catch (Exception exp) {
            throw new ConfigurationException(exp);
        }
    }

    protected File findInstallFile(WebDriverBinaryInfo binaryInfo) {
        String installPath = System.getProperty(binaryInfo.sysPropKey);
        File installFile = null;
        if (StringUtils.isNotEmpty(installPath)) {
            installFile = new File(installPath);
        }
        if (installFile != null && installFile.exists()) {
            return installFile;
        }
        installFile = new File(binaryInfo.installDir, binaryInfo.installFile);
        return installFile;
    }

    protected synchronized String install(WebDriverBinaryInfo binaryInfo) {
        File installFile = this.findInstallFile(binaryInfo);
        System.setProperty(binaryInfo.sysPropKey, installFile.getAbsolutePath());
        if (installFile.exists()) {
            LOG.info("install.exists", binaryInfo.sysPropKey, installFile.getAbsolutePath());
            return installFile.getAbsolutePath();
        }
        LOG.info("install", binaryInfo.sysPropKey);
        try {
            URL downloadUrl = new URL(binaryInfo.downloadUrl);
            File downloadFile = new File(binaryInfo.downloadDir, downloadUrl.getFile());
            if (downloadFile.exists()) {
                LOG.info("download.exists", binaryInfo.sysPropKey, downloadFile.getAbsolutePath());
            } else {
                ProxySettingService.getInstance().loadProxy();
                LOG.info("download2", binaryInfo.sysPropKey, downloadUrl, downloadFile.getAbsolutePath());
                FileUtils.copyURLToFile(downloadUrl, downloadFile);
            }
            if (downloadFile.getName().endsWith(".msi")) {
                LOG.info("installer.execute", binaryInfo.sysPropKey, downloadFile.getAbsolutePath());
                ProcessUtils.exec("msiexec", "/i", downloadFile.getAbsolutePath(), "/passive");
            } else if (StringUtils.isEmpty(binaryInfo.zipEntry)) {
                LOG.info("put", binaryInfo.sysPropKey, downloadFile.getAbsolutePath(), installFile.getAbsolutePath());
                FileUtils.copyFile(downloadFile, installFile);
            } else {
                LOG.info("open", binaryInfo.sysPropKey, downloadFile.getAbsolutePath(), installFile.getAbsolutePath());
                this.extractOne(downloadFile, binaryInfo.zipEntry, installFile);
            }
            if (!SystemUtils.IS_OS_WINDOWS) {
                ProcessUtils.exec("chmod", "u+x", installFile.getAbsolutePath());
            }
        }
        catch (IOException e) {
            throw new ConfigurationException(e);
        }
        catch (Exception exp) {
            throw new ConfigurationException(exp);
        }
        return installFile.getAbsolutePath();
    }

    private void extractOne(File srcFile, String entryName, File dstFile) throws IOException {
        if (srcFile.getName().endsWith(".zip")) {
            this.extractOneFromZip(srcFile, entryName, dstFile);
        } else if (srcFile.getName().endsWith(".tar.gz")) {
            this.extractOneFromTarGz(srcFile, entryName, dstFile);
        }
    }

    private void extractOneFromZip(File srcFile, String entryName, File dstFile) throws IOException {
        try (ZipFile zipFile = new ZipFile(srcFile);){
            Enumeration<? extends ZipEntry> enu = zipFile.entries();
            while (enu.hasMoreElements()) {
                ZipEntry zipEntry = enu.nextElement();
                if (!zipEntry.getName().equals(entryName)) continue;
                File parentDir = dstFile.getParentFile();
                if (!parentDir.exists()) {
                    parentDir.mkdirs();
                }
                InputStream is = zipFile.getInputStream(zipEntry);
                try {
                    Files.copy(is, dstFile.toPath(), new CopyOption[0]);
                }
                finally {
                    if (is == null) continue;
                    is.close();
                }
            }
        }
    }

    private void extractOneFromTarGz(File srcFile, String entryName, File dstFile) throws IOException {
        TarArchiveInputStream tarInput = new TarArchiveInputStream(new GzipCompressorInputStream(new FileInputStream(srcFile)));
        TarArchiveEntry currentEntry = tarInput.getNextTarEntry();
        while (currentEntry != null) {
            if (!currentEntry.getName().equals(entryName)) continue;
            byte[] content = new byte[(int)currentEntry.getSize()];
            IOUtils.read(tarInput, content);
            FileUtils.writeByteArrayToFile(dstFile, content);
            currentEntry = tarInput.getNextTarEntry();
        }
    }

    private String getDownloadDir(String driver) {
        return this.getRrepositoryDir(driver) + File.separatorChar + "download";
    }

    private String getInstallDir(String driver) {
        return this.getRrepositoryDir(driver) + File.separatorChar + "runtime";
    }

    String getRrepositoryDir(String driver) {
        return SitRepository.getRepositoryPath() + File.separator + "selenium" + File.separator + driver;
    }

    @Generated
    public static WebDriverInstaller getInstance() {
        return instance;
    }

    class WebDriverBinaryInfo {
        String os;
        String driver;
        String sysPropKey;
        String downloadUrl;
        String downloadDir;
        String zipEntry;
        String installDir;
        String installFile;

        public WebDriverBinaryInfo(String driver) {
            this.driver = driver;
            this.sysPropKey = "webdriver." + driver + ".driver";
            this.downloadDir = WebDriverInstaller.this.getDownloadDir(driver);
            this.installDir = WebDriverInstaller.this.getInstallDir(driver);
        }

        public WebDriverBinaryInfo(String os, String driver) {
            this(driver);
            this.os = os;
        }
    }
}

