/*
 * Decompiled with CFR 0.152.
 */
package io.sitoolkit.wt.infra.selenium;

import io.sitoolkit.wt.infra.PropertyManager;
import io.sitoolkit.wt.infra.log.SitLogger;
import io.sitoolkit.wt.infra.log.SitLoggerFactory;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PreDestroy;
import javax.annotation.Resource;
import org.openqa.selenium.WebDriver;

public class WebDriverCloser {
    private static final SitLogger LOG = SitLoggerFactory.getLogger(WebDriverCloser.class);
    private List<WebDriver> driverList = new ArrayList<WebDriver>();
    @Resource
    PropertyManager pm;

    public void register(WebDriver driver) {
        this.driverList.add(driver);
    }

    @PreDestroy
    public void preDestroy() {
        if (this.pm.isRemoteDriver()) {
            return;
        }
        this.driverList.parallelStream().forEach(driver -> {
            LOG.debug("webdriver.stop", driver);
            try {
                driver.quit();
            }
            catch (Exception e) {
                LOG.trace("trace", e.getMessage());
            }
        });
    }
}

