/*
 * Decompiled with CFR 0.152.
 */
package io.sitoolkit.wt.infra.process;

import io.sitoolkit.wt.infra.log.SitLogger;
import io.sitoolkit.wt.infra.log.SitLoggerFactory;
import io.sitoolkit.wt.infra.process.ExecuteResult;
import io.sitoolkit.wt.infra.process.StreamReader;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

public class ProcessUtils {
    static final SitLogger LOG = SitLoggerFactory.getLogger(ProcessUtils.class);

    public static void exec(String ... command) throws IOException {
        ProcessBuilder pb = new ProcessBuilder(command);
        try {
            Process process = pb.start();
            process.waitFor(30L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            LOG.warn("warn", e);
        }
    }

    public static void execute(String ... command) {
        ProcessUtils.execute(true, command);
    }

    public static ExecuteResult execute(boolean wait, String ... command) {
        ProcessBuilder builder = new ProcessBuilder(command);
        try {
            String commandStr = ProcessUtils.toCommandString(command);
            LOG.debug("execute", commandStr);
            Process process = builder.start();
            ExecutorService executor = Executors.newCachedThreadPool();
            StreamReader stdout = new StreamReader(process.toString(), process.getInputStream());
            executor.execute(stdout);
            StreamReader stderr = new StreamReader(process.toString(), process.getInputStream());
            executor.execute(stderr);
            if (!wait) {
                return new ExecuteResult(stdout.getText(), stderr.getText(), 0);
            }
            int exitValue = process.waitFor();
            return new ExecuteResult(stdout.getText(), stderr.getText(), exitValue);
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private static String toCommandString(String ... command) {
        StringBuilder sb = new StringBuilder();
        for (String cmd : command) {
            if (sb.length() > 0) {
                sb.append(" ");
            }
            sb.append("\"");
            sb.append(cmd);
            sb.append("\"");
        }
        return sb.toString();
    }
}

