/*
 * Decompiled with CFR 0.152.
 */
package io.sitoolkit.wt.infra.firefox;

import io.sitoolkit.util.buildtoolhelper.proxysetting.ProxySettingService;
import io.sitoolkit.wt.infra.MultiThreadUtils;
import io.sitoolkit.wt.infra.PropertyUtils;
import io.sitoolkit.wt.infra.SitRepository;
import io.sitoolkit.wt.infra.log.SitLogger;
import io.sitoolkit.wt.infra.log.SitLoggerFactory;
import io.sitoolkit.wt.infra.process.ProcessUtils;
import io.sitoolkit.wt.infra.resource.MessageManager;
import io.sitoolkit.wt.util.infra.util.FileIOUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.annotation.PostConstruct;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.SystemUtils;
import org.jsoup.UncheckedIOException;
import org.openqa.selenium.firefox.FirefoxBinary;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.firefox.FirefoxOptions;
import org.openqa.selenium.remote.DesiredCapabilities;

public class FirefoxManager {
    private static final SitLogger LOG = SitLoggerFactory.getLogger(FirefoxManager.class);
    private String firefoxVersion;
    private String winFirefoxDownloadUrl;
    private String winFirefoxInstallFile;
    private String macFirefoxDownloadUrl;
    private String macFirefoxInstallFile;
    private String installDir;
    private String installIni;
    private String unsupportMsg = MessageManager.getMessage("os.unsupport");

    @PostConstruct
    public void init() {
        Map<String, String> prop = PropertyUtils.loadAsMap("/firefoxinstaller-default.properties", false);
        prop.putAll(PropertyUtils.loadAsMap("/firefoxinstaller.properties", true));
        this.firefoxVersion = prop.get("firefox.version");
        this.winFirefoxDownloadUrl = prop.get("win.firefox.downloadUrl");
        this.winFirefoxInstallFile = prop.get("win.firefox.installFile");
        this.macFirefoxDownloadUrl = prop.get("mac.firefox.downloadUrl");
        this.macFirefoxInstallFile = prop.get("mac.firefox.installFile");
        this.installDir = "firefox";
        this.installIni = "ff-inst.ini";
    }

    public FirefoxDriver startWebDriver(DesiredCapabilities capabilities, List<String> arguments) {
        return MultiThreadUtils.submitWithProgress(() -> {
            FirefoxOptions options = new FirefoxOptions(capabilities);
            options.setBinary(this.getFirefoxBinary());
            options.addArguments(arguments);
            return new FirefoxDriver(options);
        });
    }

    public FirefoxBinary getFirefoxBinary() {
        Path ffBinaryFile = this.getFirefoxBinaryFile();
        if (Files.exists(ffBinaryFile, new LinkOption[0])) {
            if (this.firefoxVersion.equals(this.getFirefoxVersion())) {
                LOG.info("firefox.exist", ffBinaryFile.toString());
            } else {
                this.uninstallFirefox();
                this.installFirefox();
            }
        } else {
            LOG.info("firefox.sit.install");
            this.installFirefox();
        }
        return new FirefoxBinary(ffBinaryFile.toFile());
    }

    protected Path getFirefoxBinaryFile() {
        if (SystemUtils.IS_OS_WINDOWS) {
            return Paths.get(SitRepository.getRepositoryPath(), this.installDir, "runtime/firefox.exe");
        }
        if (SystemUtils.IS_OS_MAC) {
            return Paths.get(SitRepository.getRepositoryPath(), this.installDir, "runtime/Firefox.app/Contents/MacOS/firefox-bin");
        }
        throw new UnsupportedOperationException(this.unsupportMsg);
    }

    protected void installFirefox() {
        Path repo = Paths.get(SitRepository.getRepositoryPath(), this.installDir);
        if (!Files.exists(repo, new LinkOption[0])) {
            try {
                Files.createDirectories(repo, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        if (SystemUtils.IS_OS_WINDOWS) {
            this.installFirefoxWindows(repo);
        } else if (SystemUtils.IS_OS_MAC) {
            this.installFirefoxMacOs(repo);
        } else {
            throw new UnsupportedOperationException(this.unsupportMsg);
        }
    }

    protected void installFirefoxWindows(Path repo) {
        Path ffInstaller = Paths.get(repo.toString(), this.winFirefoxInstallFile);
        if (Files.exists(ffInstaller, new LinkOption[0])) {
            LOG.info("ffInstaller.exists", ffInstaller.toString());
        } else {
            try {
                ProxySettingService.getInstance().loadProxy();
                URL url = new URL(this.winFirefoxDownloadUrl);
                LOG.info("firefox.download", url, ffInstaller.toString());
                MultiThreadUtils.submitWithProgress(() -> {
                    FileUtils.copyURLToFile(url, ffInstaller.toFile());
                    return 0;
                });
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        LOG.info("firefox.install");
        try {
            Path iniFile = Files.createTempFile("ff-inst", ".ini", new FileAttribute[0]);
            FileIOUtils.sysRes2file(this.installIni, iniFile, true);
            MultiThreadUtils.submitWithProgress(() -> {
                ProcessUtils.execute(ffInstaller.toString(), "/INI=" + iniFile.toString());
                return 0;
            });
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    protected void installFirefoxMacOs(Path repo) {
        Path ffInstaller = Paths.get(repo.toString(), this.macFirefoxInstallFile);
        if (Files.exists(ffInstaller, new LinkOption[0])) {
            LOG.info("ffInstaller.exists", ffInstaller.toString());
        } else {
            try {
                ProxySettingService.getInstance().loadProxy();
                URL url = new URL(this.macFirefoxDownloadUrl);
                LOG.info("firefox.download", url, ffInstaller.toString());
                FileUtils.copyURLToFile(url, ffInstaller.toFile());
                ProcessUtils.execute("chmod", "777", ffInstaller.toString());
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        LOG.info("firefox.mount");
        ProcessUtils.execute("hdiutil", "attach", ffInstaller.toString());
        Path mountedFf = Paths.get("/Volumes/Firefox/Firefox.app", new String[0]);
        Path ffRuntime = Paths.get(repo.toString(), "runtime");
        LOG.info("firefox.install2", ffRuntime.toString());
        try {
            if (!Files.exists(ffRuntime, new LinkOption[0])) {
                Files.createDirectories(ffRuntime, new FileAttribute[0]);
            }
            FileIOUtils.copyDirectoryWithPermission(mountedFf, ffRuntime);
            LOG.info("firefox.unmount");
        }
        catch (IOException e) {
            try {
                throw new UncheckedIOException(e);
            }
            catch (Throwable throwable) {
                LOG.info("firefox.unmount");
                ProcessUtils.execute("hdiutil", "detach", "/Volumes/Firefox");
                throw throwable;
            }
        }
        ProcessUtils.execute("hdiutil", "detach", "/Volumes/Firefox");
    }

    protected String getFirefoxVersion() {
        String string;
        block8: {
            Properties ffProp = new Properties();
            Path firefoxIni = this.getFirefoxIni();
            InputStream iniInStream = Files.newInputStream(firefoxIni, new OpenOption[0]);
            try {
                ffProp.load(iniInStream);
                string = ffProp.getProperty("Version");
                if (iniInStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (iniInStream != null) {
                        try {
                            iniInStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            iniInStream.close();
        }
        return string;
    }

    protected Path getFirefoxIni() {
        if (SystemUtils.IS_OS_WINDOWS) {
            return Paths.get(SitRepository.getRepositoryPath(), this.installDir, "runtime/application.ini");
        }
        if (SystemUtils.IS_OS_MAC) {
            return Paths.get(SitRepository.getRepositoryPath(), this.installDir, "runtime/Firefox.app/Contents/Resources/application.ini");
        }
        throw new UnsupportedOperationException(this.unsupportMsg);
    }

    protected void uninstallFirefox() {
        LOG.info("firefox.uninstall");
        if (SystemUtils.IS_OS_WINDOWS) {
            this.uninstallFirefoxWindows();
        } else if (SystemUtils.IS_OS_MAC) {
            this.uninstallFirefoxMacOs();
        } else {
            throw new UnsupportedOperationException(this.unsupportMsg);
        }
    }

    protected void uninstallFirefoxWindows() {
        Path ffUninstaller = Paths.get(SitRepository.getRepositoryPath(), this.installDir, "runtime/uninstall/helper.exe");
        MultiThreadUtils.submitWithProgress(() -> {
            ProcessUtils.execute(ffUninstaller.toString(), "-ms");
            return 0;
        });
    }

    protected void uninstallFirefoxMacOs() {
        Path ffRuntime = Paths.get(SitRepository.getRepositoryPath(), this.installDir, "runtime");
        try {
            FileUtils.deleteDirectory(ffRuntime.toFile());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

