/*
 * Decompiled with CFR 0.152.
 */
package io.sitoolkit.wt.infra;

import io.sitoolkit.wt.infra.ConfigurationException;
import io.sitoolkit.wt.infra.log.SitLogger;
import io.sitoolkit.wt.infra.log.SitLoggerFactory;
import io.sitoolkit.wt.infra.resource.MessageManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang3.StringUtils;

public class PropertyUtils {
    private static final SitLogger LOG = SitLoggerFactory.getLogger(PropertyUtils.class);
    private static final Map<String, Properties> CACHE = new HashMap<String, Properties>();

    public static Properties load(String resourceName, boolean ignoreResourceNotFound) {
        Properties prop = new Properties();
        URL url = null;
        if (resourceName.endsWith(".xml") || resourceName.endsWith(".properties")) {
            url = PropertyUtils.class.getResource(resourceName);
        } else {
            url = PropertyUtils.class.getResource(resourceName + ".properties");
            if (url == null) {
                url = PropertyUtils.class.getResource(resourceName + ".xml");
            }
        }
        if (url == null) {
            if (ignoreResourceNotFound) {
                return prop;
            }
            throw new ConfigurationException(MessageManager.getMessage("property.not.found") + resourceName);
        }
        LOG.info("property.load", url);
        try {
            if (url.getFile().endsWith("properties")) {
                prop.load(url.openStream());
            } else {
                prop.loadFromXML(url.openStream());
            }
        }
        catch (IOException e) {
            throw new ConfigurationException(e);
        }
        return prop;
    }

    public static Map<String, String> loadAsMap(String resourceName, boolean ignoreResourceNotFound) {
        Properties prop = PropertyUtils.load(resourceName, ignoreResourceNotFound);
        HashMap<String, String> map = new HashMap<String, String>();
        for (Map.Entry<Object, Object> entry : prop.entrySet()) {
            map.put(entry.getKey().toString().trim(), entry.getValue().toString().trim());
        }
        return map;
    }

    public static void save(Object obj, File path) {
        try (FileWriter writer = new FileWriter(path);){
            TreeMap<String, String> map = new TreeMap<String, String>();
            map.putAll(BeanUtils.describe(obj));
            Properties prop = new Properties();
            for (Map.Entry entry : map.entrySet()) {
                prop.setProperty((String)entry.getKey(), StringUtils.defaultString((String)entry.getValue()));
            }
            prop.store(writer, "");
        }
        catch (Exception e) {
            throw new ConfigurationException(MessageManager.getMessage("property.save.exception"), e);
        }
    }

    public static Properties loadFromPathWithCache(String path) {
        Properties properties;
        Properties prop = CACHE.get(path);
        if (prop == null) {
            prop = new Properties();
        }
        FileInputStream fis = new FileInputStream(path);
        try {
            prop.load(fis);
            CACHE.put(path, prop);
            properties = prop;
        }
        catch (Throwable throwable) {
            try {
                try {
                    fis.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new ConfigurationException(e);
            }
        }
        fis.close();
        return properties;
    }
}

