/*
 * Decompiled with CFR 0.152.
 */
package io.sitoolkit.wt.infra;

import io.sitoolkit.wt.infra.ConfigurationException;
import io.sitoolkit.wt.infra.PropertyUtils;
import io.sitoolkit.wt.infra.log.SitLogger;
import io.sitoolkit.wt.infra.log.SitLoggerFactory;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Stream;
import javax.annotation.PostConstruct;
import lombok.Generated;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;
import org.springframework.context.support.PropertySourcesPlaceholderConfigurer;
import org.springframework.util.StringUtils;

@Configuration
@PropertySource(ignoreResourceNotFound=true, value={"classpath:sit-wt-default.properties", "classpath:sit-wt.properties"})
public class PropertyManager {
    private static final SitLogger LOG = SitLoggerFactory.getLogger(PropertyManager.class);
    @Value(value="${window.width}")
    private int windowWidth;
    @Value(value="${window.height}")
    private int windowHeight;
    @Value(value="${window.top}")
    private int windowTop;
    @Value(value="${window.left}")
    private int windowLeft;
    @Value(value="${window.shift.top}")
    private int windowShiftTop;
    @Value(value="${window.shift.left}")
    private int windowShiftLeft;
    @Value(value="${implicitlyWait}")
    private int implicitlyWait;
    @Value(value="${operationWait}")
    private int operationWait;
    @Value(value="${dialogWaitInSecond}")
    private int dialogWaitInSecond;
    @Value(value="${window.resize}")
    private boolean resizeWindow;
    @Value(value="${pagescript.dir}")
    private String pageScriptDir;
    @Value(value="${driver.type:}")
    private String driverType;
    @Value(value="${headless:false}")
    private boolean headlessMode;
    @Value(value="${browser.options:}")
    private String browserOptions;
    @Value(value="${appium.address}")
    private String appiumAddress;
    @Value(value="${screenshot.mode}")
    private String screenshotMode;
    @Value(value="${screenshot.resize}")
    private boolean screenshotResize;
    @Value(value="${screenshot.padding.width}")
    private int screenshotPaddingWidth;
    @Value(value="${screenshot.padding.height}")
    private int screenshotPaddingHeight;
    @Value(value="${selenium.screenshot.pattern}")
    private String seleniumScreenshotPattern;
    @Value(value="${connection.properties}")
    private String connectionProperties;
    @Value(value="${baseUrl:}")
    private String baseUrl;
    @Value(value="${hubUrl}")
    private String hubUrl;
    @Value(value="${sitwt.debug:false}")
    private boolean isDebug;
    @Value(value="${sitwt.cli:true}")
    private boolean isCli;
    @Value(value="${wait.timeout}")
    private int timeout;
    @Value(value="${wait.waitSpan}")
    private int waitSpan;
    private Charset csvCharset = StandardCharsets.UTF_8;
    private boolean csvHasBOM = true;
    @Value(value="${sitwt.projectDirectory:#{null}}")
    private File projectDir;
    private Map<String, String> capabilities = new HashMap<String, String>();
    private boolean isFirefoxDriver;
    private boolean isIeDriver;
    private boolean isEdgeDriver;
    private boolean isMsDriver;
    private boolean isRemoteDriver;
    private boolean isChromeDriver;
    private List<String> browserArguments = new ArrayList<String>();

    @Bean
    public static PropertySourcesPlaceholderConfigurer propertyConfigInDev() {
        PropertySourcesPlaceholderConfigurer pspc = new PropertySourcesPlaceholderConfigurer();
        pspc.setIgnoreUnresolvablePlaceholders(true);
        return pspc;
    }

    @PostConstruct
    public void init() {
        this.capabilities = PropertyUtils.loadAsMap("/capabilities", true);
        this.setDriverFlags(this.toLowerCase(this.driverType), this.toLowerCase(this.capabilities.get("browserName")));
        if (StringUtils.hasLength(this.browserOptions)) {
            Stream.of(this.browserOptions.split(",")).filter(StringUtils::hasLength).forEach(this.browserArguments::add);
        }
        if (this.isChromeDriver() && this.headlessMode) {
            this.browserArguments.add("--headless");
        }
        if (this.isFirefoxDriver() && this.headlessMode) {
            this.browserArguments.add("-headless");
        }
    }

    public void save(File dir) {
        PropertyUtils.save(this, new File(dir, "sit-wt.properties"));
    }

    void setDriverFlags(String driverType, String browserName) {
        this.isFirefoxDriver = this.equalsAny("firefox", driverType, browserName);
        this.isIeDriver = this.equalsAny("internet explorer", driverType, browserName) || "ie".equals(driverType);
        this.isEdgeDriver = this.equalsAny("edge", driverType, browserName);
        this.isMsDriver = this.isIeDriver || this.isEdgeDriver;
        this.isRemoteDriver = "remote".equals(driverType);
        this.isChromeDriver = this.equalsAny("chrome", driverType, browserName);
    }

    private String toLowerCase(String str) {
        return str == null ? "" : str.toLowerCase();
    }

    private boolean equalsAny(String str1, String ... strs) {
        for (String str : strs) {
            if (!str1.equals(str)) continue;
            return true;
        }
        return false;
    }

    public int getWindowWidth() {
        return this.windowWidth;
    }

    public int getWindowHeight() {
        return this.windowHeight;
    }

    public int getImplicitlyWait() {
        return this.implicitlyWait;
    }

    public boolean isResizeWindow() {
        return this.resizeWindow;
    }

    public String getPageScriptDir() {
        return this.pageScriptDir;
    }

    public String getDriverType() {
        return this.driverType;
    }

    public String getDriverTypeInCapabilities() {
        return this.capabilities.get("browserName");
    }

    public boolean isRemoteDriver() {
        return this.isRemoteDriver;
    }

    public boolean isFirefoxDriver() {
        return this.isFirefoxDriver;
    }

    public boolean isEdgeDriver() {
        return this.isEdgeDriver;
    }

    public boolean isIeDriver() {
        return this.isIeDriver;
    }

    public boolean isMsDriver() {
        return this.isMsDriver;
    }

    public boolean isSafariDriver() {
        return "safari".equalsIgnoreCase(this.driverType);
    }

    public boolean isChromeDriver() {
        return this.isChromeDriver;
    }

    public URL getAppiumAddress() {
        try {
            return this.appiumAddress == null ? null : new URL(this.appiumAddress);
        }
        catch (MalformedURLException e) {
            throw new ConfigurationException("appium.address", e);
        }
    }

    public boolean isScreenshotResize() {
        return this.screenshotResize;
    }

    public int getScreenshotPaddingWidth() {
        return this.screenshotPaddingWidth;
    }

    public int getScreenshotPaddingHeight() {
        return this.screenshotPaddingHeight;
    }

    public Pattern getSeleniumScreenshotPattern() {
        try {
            return this.seleniumScreenshotPattern == null ? null : Pattern.compile(this.seleniumScreenshotPattern);
        }
        catch (PatternSyntaxException e) {
            throw new ConfigurationException("selenium.screenshot.pattern", e);
        }
    }

    public String getScreenthotMode() {
        return this.screenshotMode;
    }

    public String getConnectionProperties() {
        return this.connectionProperties;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public String getHubUrl() {
        return this.hubUrl;
    }

    public int getWindowTop() {
        return this.windowTop;
    }

    public int getWindowLeft() {
        return this.windowLeft;
    }

    public int getOperationWait() {
        return this.operationWait;
    }

    public int getWindowShiftTop() {
        return this.windowShiftTop;
    }

    public int getWindowShiftLeft() {
        return this.windowShiftLeft;
    }

    public int getDialogWaitInSecond() {
        return this.dialogWaitInSecond;
    }

    public Map<String, String> getCapabilities() {
        return this.capabilities;
    }

    public List<String> getBrowserArguments() {
        return this.browserArguments;
    }

    public boolean isDebug() {
        return this.isDebug;
    }

    public boolean isCli() {
        return this.isCli;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public int getWaitSpan() {
        return this.waitSpan;
    }

    @Generated
    public void setDriverType(String driverType) {
        this.driverType = driverType;
    }

    @Generated
    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    @Generated
    public void setDebug(boolean isDebug) {
        this.isDebug = isDebug;
    }

    @Generated
    public void setCsvCharset(Charset csvCharset) {
        this.csvCharset = csvCharset;
    }

    @Generated
    public Charset getCsvCharset() {
        return this.csvCharset;
    }

    @Generated
    public void setCsvHasBOM(boolean csvHasBOM) {
        this.csvHasBOM = csvHasBOM;
    }

    @Generated
    public boolean isCsvHasBOM() {
        return this.csvHasBOM;
    }

    @Generated
    public File getProjectDir() {
        return this.projectDir;
    }
}

