/*
 * Decompiled with CFR 0.152.
 */
package io.sitoolkit.wt.infra;

import io.sitoolkit.wt.infra.log.SitLogger;
import io.sitoolkit.wt.infra.log.SitLoggerFactory;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class MultiThreadUtils {
    private static final SitLogger LOG = SitLoggerFactory.getLogger(MultiThreadUtils.class);

    public static <T> T submitWithProgress(Callable<T> callable) {
        ExecutorService executor = Executors.newSingleThreadExecutor();
        Future<T> future = executor.submit(callable);
        int loop = 0;
        while (!future.isDone()) {
            try {
                Thread.sleep(300L);
            }
            catch (InterruptedException e) {
                LOG.warn("warn", e);
            }
            if (loop++ % 7 != 1) continue;
            System.out.println(":");
        }
        executor.shutdown();
        try {
            return future.get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }
}

