/*
 * Decompiled with CFR 0.152.
 */
package io.sitoolkit.wt.infra;

import io.sitoolkit.wt.infra.log.SitLogger;
import io.sitoolkit.wt.infra.log.SitLoggerFactory;
import org.apache.commons.lang3.StringUtils;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.ParserContext;
import org.springframework.expression.common.TemplateParserContext;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;

public class ELSupport {
    protected final SitLogger LOG = SitLoggerFactory.getLogger(this.getClass());
    protected ExpressionParser parser = new SpelExpressionParser();
    protected ParserContext parserContext = new TemplateParserContext();
    private EvaluationContext ctx;
    protected Object rootObject;

    public ELSupport(Object rootObject) {
        this.rootObject = rootObject;
        this.ctx = new StandardEvaluationContext(rootObject);
    }

    public String evaluate(String value) {
        if (StringUtils.isEmpty(value)) {
            return "";
        }
        Expression exp = this.parser.parseExpression(value, this.parserContext);
        return StringUtils.defaultString(this.ctx == null ? exp.getValue(String.class) : exp.getValue(this.ctx, String.class));
    }

    public Object getRootObject() {
        return this.rootObject;
    }

    public void setRootObject(Object rootObject) {
        this.rootObject = rootObject;
    }
}

