/*
 * Decompiled with CFR 0.152.
 */
package io.sitoolkit.wt.gui.pres.editor.testscript;

import io.sitoolkit.wt.domain.testscript.TestScript;
import io.sitoolkit.wt.domain.testscript.TestStep;
import io.sitoolkit.wt.gui.pres.editor.testscript.ClipboardScriptAccessor;
import io.sitoolkit.wt.gui.pres.editor.testscript.ClipboardScriptAccessorFxImpl;
import io.sitoolkit.wt.gui.pres.editor.testscript.ScriptEditorCell;
import io.sitoolkit.wt.gui.pres.editor.testscript.ScriptEditorRow;
import io.sitoolkit.wt.gui.pres.editor.testscript.ScriptEditorTableCell;
import io.sitoolkit.wt.gui.pres.editor.testscript.ScriptEditorTableRowPickerCell;
import io.sitoolkit.wt.gui.pres.editor.testscript.TestScriptEditor;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javafx.beans.property.Property;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.IndexedCell;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableColumnBase;
import javafx.scene.control.TablePosition;
import javafx.scene.control.TableView;
import javafx.scene.input.ContextMenuEvent;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.KeyEvent;
import javafx.util.Callback;
import org.apache.commons.lang3.StringUtils;

public class TestScriptEditorFxImpl
implements TestScriptEditor {
    private static final int COLUMN_INDEX_FIRST_CASE = 8;
    private static final int SCRIPT_HEADER_INDEX_BREAK_POINT = 7;
    private static final double PICKER_COLUMN_WIDTH = 15.0;
    private TableView<ScriptEditorRow> tableView = new TableView();
    private ClipboardScriptAccessor clipboardAccessor;
    private String caseNoPrefix = "case_";
    public static final KeyCodeCombination KEY_CODE_COPY = new KeyCodeCombination(KeyCode.C, KeyCombination.SHORTCUT_DOWN);
    public static final KeyCodeCombination KEY_CODE_PASTE = new KeyCodeCombination(KeyCode.V, KeyCombination.SHORTCUT_DOWN);
    private int lastContextMenuRequestedRowIndex = -1;

    public TestScriptEditorFxImpl() {
        this.tableView.setEditable(true);
        this.tableView.getSelectionModel().setCellSelectionEnabled(true);
        this.tableView.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        this.tableView.getStylesheets().add(this.getClass().getResource("/testScriptEditor.css").toExternalForm());
        this.tableView.setOnKeyPressed(this::onKeyPressed);
        this.tableView.setOnContextMenuRequested(this::onContextMenuRequested);
    }

    @Override
    public void load(TestScript testScript) {
        this.caseNoPrefix = testScript.getCaseNoPrefix();
        this.tableView.setItems(this.buildEditorRows(testScript));
        this.tableView.getColumns().setAll((Collection<TableColumn<ScriptEditorRow, ?>>)this.buildEditorColumns(testScript));
        this.tableView.setId(testScript.getScriptFile().getAbsolutePath());
    }

    private List<TableColumn<ScriptEditorRow, ScriptEditorCell>> buildEditorColumns(TestScript testScript) {
        ArrayList<TableColumn<ScriptEditorRow, ScriptEditorCell>> columns = new ArrayList<TableColumn<ScriptEditorRow, ScriptEditorCell>>();
        columns.add(this.buildPickerColumn());
        int colIndex = 0;
        for (String headerName : testScript.getHeaders()) {
            if (colIndex != 7) {
                String caseNo = this.getCaseNo(testScript, headerName);
                columns.add(this.buildEditorColumn(headerName, colIndex, caseNo));
            }
            ++colIndex;
        }
        return columns;
    }

    private TableColumn<ScriptEditorRow, ScriptEditorCell> buildPickerColumn() {
        TableColumn<ScriptEditorRow, ScriptEditorCell> col = new TableColumn<ScriptEditorRow, ScriptEditorCell>("");
        col.setCellFactory(l -> new ScriptEditorTableRowPickerCell());
        col.setCellValueFactory(p -> ((ScriptEditorRow)p.getValue()).breakpointProperty());
        col.setEditable(false);
        col.setSortable(false);
        col.setReorderable(false);
        col.setResizable(false);
        col.setPrefWidth(15.0);
        return col;
    }

    private TableColumn<ScriptEditorRow, ScriptEditorCell> buildEditorColumn(String headerName, int columnIndex, String caseNo) {
        TableColumn<ScriptEditorRow, ScriptEditorCell> col = new TableColumn<ScriptEditorRow, ScriptEditorCell>(headerName);
        col.setCellFactory(l -> new ScriptEditorTableCell());
        col.setCellValueFactory(this.createCellValueFactory(columnIndex, caseNo));
        col.setEditable(true);
        col.setSortable(false);
        col.setReorderable(false);
        return col;
    }

    private String getCaseNo(TestScript testScript, String headerName) {
        return StringUtils.substringAfter(headerName, testScript.getCaseNoPrefix());
    }

    private String getCaseNo(String headerName) {
        return StringUtils.substringAfter(headerName, this.caseNoPrefix);
    }

    private String getCaseNo(int caseIndex) {
        return this.getCaseNo(((TableColumn)this.tableView.getColumns().get(8 + caseIndex)).getText());
    }

    private String getCaseHeaderName(String caseNo) {
        return this.caseNoPrefix + caseNo;
    }

    private Callback<TableColumn.CellDataFeatures<ScriptEditorRow, ScriptEditorCell>, ObservableValue<ScriptEditorCell>> createCellValueFactory(int columnIndex, String caseNo) {
        switch (columnIndex) {
            case 0: {
                return p -> ((ScriptEditorRow)p.getValue()).noProperty();
            }
            case 1: {
                return p -> ((ScriptEditorRow)p.getValue()).itemNameProperty();
            }
            case 2: {
                return p -> ((ScriptEditorRow)p.getValue()).operationNameProperty();
            }
            case 3: {
                return p -> ((ScriptEditorRow)p.getValue()).locatorTypeProperty();
            }
            case 4: {
                return p -> ((ScriptEditorRow)p.getValue()).locatorProperty();
            }
            case 5: {
                return p -> ((ScriptEditorRow)p.getValue()).dataTypeProperty();
            }
            case 6: {
                return p -> ((ScriptEditorRow)p.getValue()).screenshotTimingProperty();
            }
            case 7: {
                return p -> ((ScriptEditorRow)p.getValue()).breakpointProperty();
            }
        }
        return p -> ((ScriptEditorRow)p.getValue()).testDataProperty(caseNo);
    }

    private ObservableList<ScriptEditorRow> buildEditorRows(TestScript testScript) {
        return testScript.getTestStepList().stream().map(ScriptEditorRow::createFromTestStep).collect(Collectors.toCollection(FXCollections::observableArrayList));
    }

    @Override
    public ContextMenu getContextMenu() {
        if (this.tableView.getContextMenu() == null) {
            this.tableView.setContextMenu(new ContextMenu());
        }
        return this.tableView.getContextMenu();
    }

    @Override
    public TestScript buildTestScript() {
        TestScript testScript = new TestScript();
        testScript.setScriptFile(new File(this.tableView.getId()));
        List headers = this.tableView.getColumns().stream().map(TableColumnBase::getText).collect(Collectors.toList());
        List caseNoList = headers.stream().skip(8L).map(header -> this.getCaseNo(testScript, (String)header)).collect(Collectors.toList());
        List<TestStep> testStepList = this.tableView.getItems().stream().map(row -> row.buildTestStep(caseNoList)).collect(Collectors.toList());
        headers.stream().forEach(header -> testScript.addHeader((String)header));
        testScript.setTestStepList(testStepList);
        return testScript;
    }

    @Override
    public void setDebugStyle(int nextStepIndex, int caseIndex) {
        this.removeDebugStyle();
        ((ScriptEditorRow)this.tableView.getItems().get(nextStepIndex)).setDebugStep();
        this.tableView.getItems().forEach(row -> row.setDebugCase(this.getCaseNo(caseIndex)));
    }

    @Override
    public void removeDebugStyle() {
        this.tableView.getItems().forEach(ScriptEditorRow::removeDebugCase);
        this.tableView.getItems().forEach(ScriptEditorRow::removeDebugStep);
    }

    @Override
    public boolean insertTestCase() {
        return this.insertTestCases(this.getSelectedCaseCount());
    }

    @Override
    public boolean insertTestCases(int count) {
        Optional<Integer> insertPosition = this.getInsertCasePosition();
        insertPosition.ifPresent(colPosition -> this.insertTestCases((int)colPosition, count));
        return insertPosition.isPresent();
    }

    private void insertTestCases(int colPosition, int count) {
        ObservableList<TableColumn<ScriptEditorRow, ?>> columns = this.tableView.getColumns();
        for (int i = 0; i < count; ++i) {
            String caseNo = String.format("%04d", columns.size() - 8 + 1);
            columns.add(colPosition + i, this.buildEditorColumn(this.getCaseHeaderName(caseNo), colPosition + i, caseNo));
        }
        this.getSelection().clearAndSelect(0, (TableColumn)this.tableView.getColumns().get(colPosition));
    }

    @Override
    public void appendTestCase() {
        this.appendTestCases(1);
    }

    @Override
    public void appendTestCases(int count) {
        this.insertTestCases(this.tableView.getColumns().size(), count);
    }

    @Override
    public void deleteTestCase() {
        this.getSelectedCaseIndexes().stream().sorted(Comparator.reverseOrder()).mapToInt(Integer::intValue).forEach(this.tableView.getColumns()::remove);
    }

    @Override
    public boolean insertTestStep() {
        return this.insertTestSteps(this.getSelectedRowCount());
    }

    @Override
    public boolean insertTestSteps(int count) {
        Optional<Integer> insertPosition = this.getInsertRowPosition();
        insertPosition.ifPresent(rowPosition -> this.insertTestSteps((int)rowPosition, count));
        return insertPosition.isPresent();
    }

    private void insertTestSteps(int rowPosition, int count) {
        ObservableList<ScriptEditorRow> rows = this.tableView.getItems();
        for (int i = 0; i < count; ++i) {
            rows.add(rowPosition, new ScriptEditorRow());
        }
        this.getSelection().clearAndSelect(rowPosition, (TableColumn)this.tableView.getColumns().get(0));
    }

    @Override
    public void appendTestStep() {
        this.appendTestSteps(1);
    }

    @Override
    public void appendTestSteps(int count) {
        this.insertTestSteps(this.tableView.getItems().size(), count);
    }

    @Override
    public void deleteTestStep() {
        this.tableView.getItems().removeAll(this.getSelection().getSelectedItems());
        this.getSelection().clearSelection();
    }

    @Override
    public boolean isCellSelected() {
        return this.getSelection().getSelectedItem() != null;
    }

    @Override
    public boolean isCaseSelected() {
        return !this.getSelectedCaseIndexes().isEmpty();
    }

    @Override
    public boolean isStepSelected() {
        return this.getSelection().getSelectedItem() != null;
    }

    @Override
    public boolean isCaseInsertable() {
        return this.getInsertCasePosition().isPresent();
    }

    @Override
    public boolean isStepInsertable() {
        return this.getInsertRowPosition().isPresent();
    }

    @Override
    public void toggleBreakpoint() {
        int index = this.lastContextMenuRequestedRowIndex;
        if (0 <= index && index < this.tableView.getItems().size()) {
            ((ScriptEditorRow)this.tableView.getItems().get(index)).toggleBreakpoint();
        }
    }

    @Override
    public Node getSpreadSheet() {
        return this.tableView;
    }

    TableView.TableViewSelectionModel<ScriptEditorRow> getSelection() {
        return this.tableView.getSelectionModel();
    }

    private int getSelectedRowCount() {
        return (int)this.getSelection().getSelectedIndices().stream().distinct().count();
    }

    private int getSelectedCaseCount() {
        return (int)this.getSelectedCaseIndexes().stream().distinct().count();
    }

    private Optional<Integer> getInsertRowPosition() {
        return this.getSelection().getSelectedIndices().stream().min(Comparator.naturalOrder());
    }

    private Optional<Integer> getInsertCasePosition() {
        return this.getSelectedCaseIndexes().stream().min(Comparator.naturalOrder());
    }

    private Set<Integer> getSelectedCaseIndexes() {
        Set<Integer> selectedColumnIndexes = this.getSelection().getSelectedCells().stream().map(TablePosition::getColumn).distinct().collect(Collectors.toSet());
        boolean onlyCaseSelected = selectedColumnIndexes.stream().allMatch(this::isCaseColumn);
        return onlyCaseSelected ? selectedColumnIndexes : Collections.emptySet();
    }

    private boolean isCaseColumn(int columnPosition) {
        return columnPosition >= 8;
    }

    @Override
    public ClipboardScriptAccessor getClipboardAccessor() {
        if (this.clipboardAccessor == null) {
            this.clipboardAccessor = new ClipboardScriptAccessorFxImpl(this);
        }
        return this.clipboardAccessor;
    }

    public String getCellValue(int row, int column) {
        if (this.isInRange(row, column)) {
            return ((ScriptEditorCell)this.getProperty(row, column).getValue()).getValue();
        }
        return null;
    }

    public void setCellValue(int row, int column, String value) {
        Property<ScriptEditorCell> cellProperty;
        if (this.isInRange(row, column) && ((ScriptEditorCell)(cellProperty = this.getProperty(row, column)).getValue()).getInputRule().match(value)) {
            cellProperty.setValue(((ScriptEditorCell)cellProperty.getValue()).toBuilder().value(value).build());
        }
    }

    private boolean isInRange(int row, int column) {
        return 0 <= row && row < this.tableView.getItems().size() && 0 <= column && column < this.tableView.getColumns().size();
    }

    private Property<ScriptEditorCell> getProperty(int row, int column) {
        return (Property)((TableColumn)this.tableView.getColumns().get(column)).getCellObservableValue(row);
    }

    public int getRowCount() {
        return this.tableView.getItems().size();
    }

    public int getColumnCount() {
        return this.tableView.getColumns().size();
    }

    public void onKeyPressed(KeyEvent event) {
        if (KEY_CODE_COPY.match(event)) {
            this.getClipboardAccessor().copy();
        }
        if (KEY_CODE_PASTE.match(event)) {
            this.getClipboardAccessor().paste();
        }
    }

    public void onContextMenuRequested(ContextMenuEvent event) {
        this.lastContextMenuRequestedRowIndex = this.isClickedOnCell(event) ? ((IndexedCell)event.getTarget()).getIndex() : (this.isClickedOnCellText(event) ? ((IndexedCell)((Node)event.getTarget()).getParent()).getIndex() : -1);
    }

    private boolean isClickedOnCell(ContextMenuEvent event) {
        return event.getTarget() instanceof IndexedCell;
    }

    private boolean isClickedOnCellText(ContextMenuEvent event) {
        return ((Node)event.getTarget()).getParent() instanceof IndexedCell;
    }
}

