/*
 * Decompiled with CFR 0.152.
 */
package io.sitoolkit.wt.gui.pres.editor.testscript;

import io.sitoolkit.wt.gui.pres.editor.testscript.ScriptEditorCell;
import io.sitoolkit.wt.gui.pres.editor.testscript.ScriptEditorRow;
import javafx.collections.FXCollections;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.Control;
import javafx.scene.control.TableCell;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyCode;
import javafx.util.converter.DefaultStringConverter;
import lombok.Generated;

public class ScriptEditorTableCell
extends TableCell<ScriptEditorRow, ScriptEditorCell> {
    private TextField textField;
    private ChoiceBox<String> choiceBox;
    private Control editingControl;

    @Override
    public void startEdit() {
        if (!(this.isEditable() && this.getTableView().isEditable() && this.getTableColumn().isEditable() && ((ScriptEditorCell)this.getItem()).isEditable())) {
            return;
        }
        super.startEdit();
        if (this.isEditing()) {
            this.editingControl = this.prepareEditControl();
            this.setText(null);
            this.setGraphic(this.editingControl);
            this.editingControl.requestFocus();
        }
    }

    @Override
    public void cancelEdit() {
        if (this.editingControl instanceof TextField && this.getTableView().getEditingCell() != null) {
            TextField field = (TextField)this.editingControl;
            this.commitEdit(field.getText());
        } else {
            super.cancelEdit();
            this.setText(this.getItemText());
            this.setGraphic(null);
        }
    }

    @Override
    public void updateItem(ScriptEditorCell item, boolean empty) {
        super.updateItem(item, empty);
        if (this.isEmpty()) {
            this.setText(null);
            this.setGraphic(null);
        } else {
            if (this.isEditing()) {
                if (this.editingControl != null) {
                    this.setTextToControl(this.editingControl, this.getItemText());
                }
                this.setText(null);
                this.setGraphic(this.editingControl);
            } else {
                this.setText(this.getItemText());
                this.setGraphic(null);
            }
            this.updateStyle();
        }
    }

    private void updateStyle() {
        this.getStyleClass().remove("debugCase");
        this.getStyleClass().remove("debugStep");
        this.getStyleClass().remove("non-editable");
        if (((ScriptEditorCell)this.getItem()).isDebugCase()) {
            this.getStyleClass().add("debugCase");
        }
        if (((ScriptEditorCell)this.getItem()).isDebugStep()) {
            this.getStyleClass().add("debugStep");
        }
        if (!((ScriptEditorCell)this.getItem()).isEditable()) {
            this.getStyleClass().add("non-editable");
        }
    }

    private String getItemText() {
        return ((ScriptEditorCell)this.getItem()).getValue();
    }

    @Override
    private void commitEdit(String text) {
        if (((ScriptEditorCell)this.getItem()).getInputRule().match(text)) {
            this.commitEdit(((ScriptEditorCell)this.getItem()).toBuilder().value(text).build());
        }
    }

    private Control prepareEditControl() {
        if (this.getItem() != null && ((ScriptEditorCell)this.getItem()).isChoice()) {
            if (this.choiceBox == null) {
                this.choiceBox = this.createChoiceBox();
            }
            this.choiceBox.setItems(FXCollections.observableList(((ScriptEditorCell)this.getItem()).getChoices()));
            this.setTextToControl(this.choiceBox, this.getItemText());
            return this.choiceBox;
        }
        if (this.textField == null) {
            this.textField = this.createTextField();
        }
        this.setTextToControl(this.textField, this.getItemText());
        this.textField.selectAll();
        return this.textField;
    }

    private ChoiceBox<String> createChoiceBox() {
        ChoiceBox<String> choice = new ChoiceBox<String>();
        choice.setMaxWidth(Double.MAX_VALUE);
        choice.setConverter(new DefaultStringConverter());
        choice.showingProperty().addListener(o -> {
            if (!choice.isShowing()) {
                this.commitEdit((String)choice.getSelectionModel().getSelectedItem());
            }
        });
        return choice;
    }

    private TextField createTextField() {
        TextField textInput = new TextField();
        textInput.setOnAction(event -> {
            this.commitEdit(textInput.getText());
            event.consume();
        });
        textInput.setOnKeyReleased(t -> {
            if (t.getCode() == KeyCode.ESCAPE) {
                this.cancelEdit();
                t.consume();
            }
        });
        return textInput;
    }

    private void setTextToControl(Control editControl, String text) {
        if (editControl instanceof TextField) {
            TextField field = (TextField)editControl;
            field.setText(text);
        } else if (editControl instanceof ChoiceBox) {
            ChoiceBox choice = (ChoiceBox)editControl;
            choice.getSelectionModel().select(text);
        } else {
            throw new IllegalArgumentException("not supported control:" + editControl);
        }
    }

    @Generated
    public ScriptEditorTableCell() {
    }
}

