/*
 * Decompiled with CFR 0.152.
 */
package io.sitoolkit.wt.gui.pres;

import io.sitoolkit.wt.domain.tester.TestResult;
import io.sitoolkit.wt.gui.app.test.TestExitCallback;
import io.sitoolkit.wt.gui.app.test.TestService;
import io.sitoolkit.wt.gui.domain.project.ProjectState;
import io.sitoolkit.wt.gui.domain.test.DebugListenerFinder;
import io.sitoolkit.wt.gui.domain.test.SitWtRuntimeUtils;
import io.sitoolkit.wt.gui.domain.test.TestRunParams;
import io.sitoolkit.wt.gui.infra.config.PropertyManager;
import io.sitoolkit.wt.gui.infra.fx.FxUtils;
import io.sitoolkit.wt.gui.pres.FileOpenable;
import io.sitoolkit.wt.gui.pres.FileSaver;
import io.sitoolkit.wt.gui.pres.FileTreeController;
import io.sitoolkit.wt.gui.pres.MessageView;
import io.sitoolkit.wt.gui.pres.TestRunnable;
import io.sitoolkit.wt.util.infra.process.ConversationProcess;
import io.sitoolkit.wt.util.infra.util.SystemUtils;
import java.io.File;
import java.net.URL;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Alert;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.ToolBar;
import lombok.Generated;

public class TestToolbarController
implements Initializable,
TestRunnable {
    @FXML
    private ToolBar startGroup;
    @FXML
    private ToolBar runningGroup;
    @FXML
    private ToolBar debugGroup;
    @FXML
    private ChoiceBox<String> browserChoice;
    @FXML
    private ComboBox<String> baseUrlCombo;
    @FXML
    private ToggleButton compareToggle;
    @FXML
    private Label pauseButton;
    @FXML
    private Label restartButton;
    @FXML
    private TextField stepNoText;
    @FXML
    private TextField locatorText;
    private FileTreeController fileTreeController;
    private MessageView messageView;
    private ConversationProcess testProcess;
    private String sessionId;
    private BooleanProperty pausing = new SimpleBooleanProperty(false);
    private ProjectState projectState;
    private DebugListenerFinder debugListenerFinder;
    private FileOpenable evidenceOpenable;
    private FileSaver fileSaver;
    TestService testService;

    @Override
    public void initialize(URL location, ResourceBundle resources) {
        this.browserChoice.getItems().addAll((Collection<String>)SystemUtils.getBrowsers());
        FxUtils.bindVisible(this.pauseButton, this.pausing.not());
        FxUtils.bindVisible(this.restartButton, this.pausing);
    }

    public void initialize(MessageView messageView, FileTreeController fileTreeController, ProjectState projectState, DebugListenerFinder debugListenerFinder, FileOpenable evidenceOpenable, FileSaver fileSaver) {
        this.projectState = projectState;
        this.fileTreeController = fileTreeController;
        this.messageView = messageView;
        this.debugListenerFinder = debugListenerFinder;
        this.evidenceOpenable = evidenceOpenable;
        this.fileSaver = fileSaver;
        FxUtils.bindVisible(this.startGroup, projectState.isLoaded());
        FxUtils.bindVisible(this.runningGroup, projectState.isRunning());
        FxUtils.bindVisible(this.debugGroup, projectState.isDebugging());
    }

    public void loadProject() {
        List<String> baseUrls = PropertyManager.get().getBaseUrls();
        if (!baseUrls.isEmpty()) {
            this.baseUrlCombo.getItems().addAll((Collection<String>)baseUrls);
            this.baseUrlCombo.setValue(baseUrls.get(0));
        }
    }

    public void destroy() {
        PropertyManager.get().setBaseUrls(this.baseUrlCombo.getItems());
        if (this.testProcess != null) {
            this.testProcess.destroy();
        }
        this.testService.destroy();
    }

    @Override
    @FXML
    public void run() {
        this.messageView.startMsg("\u30c6\u30b9\u30c8\u3092\u5b9f\u884c\u3057\u307e\u3059\u3002");
        this.runTest(false, false);
    }

    @FXML
    public void debug() {
        this.messageView.startMsg("\u30c6\u30b9\u30c8\u3092\u30c7\u30d0\u30c3\u30b0\u3057\u307e\u3059\u3002");
        this.runTest(true, false);
    }

    @FXML
    public void runParallel() {
        this.messageView.startMsg("\u30c6\u30b9\u30c8\u3092\u4e26\u5217\u5b9f\u884c\u3057\u307e\u3059\u3002");
        this.runTest(false, true);
    }

    @Override
    public void runTest(boolean isDebug, boolean isParallel, File testScript, List<String> caseNos) {
        this.messageView.startMsg("\u30c6\u30b9\u30c8\u3092\u5b9f\u884c\u3057\u307e\u3059\u3002");
        this.runTest(isDebug, false, SitWtRuntimeUtils.buildScriptStr(testScript, caseNos));
    }

    private void runTest(boolean isDebug, boolean isParallel) {
        this.runTest(isDebug, isParallel, SitWtRuntimeUtils.buildScriptStr(this.fileTreeController.getSelectedItems(true)));
    }

    private void runTest(boolean isDebug, boolean isParallel, String targetScriptStr) {
        List<Path> scriptPaths;
        this.fileSaver.save();
        this.projectState.setState(isDebug ? ProjectState.State.DEBUGGING : ProjectState.State.RUNNING);
        TestRunParams params = new TestRunParams();
        params.setTargetScripts(targetScriptStr);
        params.setBaseDir(this.projectState.getBaseDir());
        params.setDebug(isDebug);
        params.setParallel(isParallel);
        params.setCompareScreenshot(this.compareToggle.isSelected());
        params.setDriverType(this.getDriverType());
        params.setBaseUrl(this.getBaseUrl());
        if (isDebug && !isParallel && (scriptPaths = SitWtRuntimeUtils.decodeScrintStr(targetScriptStr)).size() == 1) {
            this.debugListenerFinder.find(scriptPaths.get(0)).ifPresent(params::setDebugListener);
        }
        this.addBaseUrl(params.getBaseUrl());
        TestExitCallback callback = testResults -> {
            this.projectState.reset();
            testResults.stream().map(TestResult::getEvidenceFile).map(Path::toFile).forEach(this.evidenceOpenable::open);
            Platform.runLater(() -> this.messageView.addMsg("\u30c6\u30b9\u30c8\u3092\u7d42\u4e86\u3057\u307e\u3059\u3002"));
        };
        String sessionId = this.testService.runTest(params, callback);
        if (sessionId == null) {
            Alert alert = new Alert(Alert.AlertType.INFORMATION);
            alert.setTitle("");
            alert.setContentText("");
            alert.setHeaderText("\u5b9f\u884c\u3059\u308b\u30c6\u30b9\u30c8\u30b9\u30af\u30ea\u30d7\u30c8\u3092\u9078\u629e\u3057\u3066\u304f\u3060\u3055\u3044\u3002\u30c6\u30b9\u30c8\u30b9\u30af\u30ea\u30d7\u30c8\u306e\u62e1\u5f35\u5b50\u306fcsv\u3001html\u3067\u3059\u3002");
            alert.show();
            this.projectState.reset();
        } else {
            this.sessionId = sessionId;
        }
    }

    private void addBaseUrl(String baseUrl) {
        ObservableList<String> items = this.baseUrlCombo.getItems();
        int limit = PropertyManager.get().getBaseUrlLimit();
        if (!items.contains(baseUrl)) {
            items.add(0, baseUrl);
        }
        if (items.size() > limit) {
            items.remove(limit);
        }
        this.baseUrlCombo.setValue(baseUrl);
    }

    @FXML
    public void pause() {
        this.testService.pause(this.sessionId);
        this.pausing.set(true);
    }

    @FXML
    public void restart() {
        String stepNo = this.stepNoText.getText();
        this.testService.restart(this.sessionId, stepNo);
        this.pausing.set(false);
    }

    @FXML
    public void back() {
        this.testService.back(this.sessionId);
    }

    @FXML
    public void forward() {
        this.testService.forward(this.sessionId);
    }

    @FXML
    public void export() {
        this.testService.export(this.sessionId);
    }

    @FXML
    public void checkLocator() {
        String locatorStr = this.locatorText.getText();
        this.testService.checkLocator(this.sessionId, locatorStr);
    }

    @FXML
    public void quit() {
        this.testService.stopTest(this.sessionId);
        this.projectState.reset();
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrlCombo.setValue(baseUrl);
    }

    public String getBaseUrl() {
        return this.baseUrlCombo.getEditor().getText().trim();
    }

    public String getDriverType() {
        return this.browserChoice.getValue();
    }

    @Generated
    public BooleanProperty getPausing() {
        return this.pausing;
    }
}

