/*
 * Decompiled with CFR 0.152.
 */
package io.sitoolkit.wt.gui.pres;

import io.sitoolkit.util.buildtoolhelper.proxysetting.ProxySettingService;
import io.sitoolkit.wt.gui.infra.config.ApplicationConfig;
import io.sitoolkit.wt.gui.infra.config.PropertyManager;
import io.sitoolkit.wt.gui.infra.fx.FxContext;
import io.sitoolkit.wt.gui.pres.AppController;
import io.sitoolkit.wt.infra.log.SitLogger;
import io.sitoolkit.wt.infra.log.SitLoggerFactory;
import io.sitoolkit.wt.util.infra.concurrent.ExecutorContainer;
import io.sitoolkit.wt.util.infra.util.SystemUtils;
import java.util.ResourceBundle;
import javafx.application.Application;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.image.Image;
import javafx.stage.Stage;
import javafx.stage.WindowEvent;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;

public class SitWtApplication
extends Application {
    private static final SitLogger LOG = SitLoggerFactory.getLogger(SitWtApplication.class);
    private AppController controller;
    private ConfigurableApplicationContext appCtx;

    public static void launchApplication(String[] args) {
        LOG.info("app.envInfo", SystemUtils.getEnvironmentInfo());
        SitWtApplication.launch(args);
    }

    @Override
    public void start(Stage primaryStage) throws Exception {
        Thread.setDefaultUncaughtExceptionHandler((thread, throwable) -> {
            LOG.error("app.unexpectedException", throwable);
            Alert alert = new Alert(Alert.AlertType.ERROR);
            alert.setContentText("\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002");
            alert.show();
        });
        FxContext.setPrimaryStage(primaryStage);
        FxContext.setHostServices(this.getHostServices());
        ProxySettingService.getInstance().loadProxy();
        primaryStage.setTitle("SI-Toolkit for Web Testing");
        FXMLLoader loader = new FXMLLoader(this.getClass().getResource("/App.fxml"));
        loader.setResources(ResourceBundle.getBundle("message.message"));
        this.appCtx = new AnnotationConfigApplicationContext(ApplicationConfig.class);
        loader.setControllerFactory(this.appCtx::getBean);
        Parent root = (Parent)loader.load();
        this.controller = (AppController)loader.getController();
        primaryStage.addEventHandler(WindowEvent.WINDOW_SHOWN, event -> this.controller.postInit());
        Scene scene = new Scene(root);
        scene.getStylesheets().add(this.getClass().getResource("/style.css").toExternalForm());
        primaryStage.setScene(scene);
        primaryStage.getIcons().add(new Image("/icon/sitoolkit.png"));
        primaryStage.show();
    }

    @Override
    public void stop() throws Exception {
        this.controller.destroy();
        this.appCtx.close();
        PropertyManager.get().save();
        ExecutorContainer.get().shutdown();
    }
}

