/*
 * Decompiled with CFR 0.152.
 */
package io.sitoolkit.wt.gui.pres;

import io.sitoolkit.wt.gui.app.sample.SampleService;
import io.sitoolkit.wt.gui.domain.project.ProjectState;
import io.sitoolkit.wt.gui.domain.sample.SampleStartedCallback;
import io.sitoolkit.wt.gui.infra.fx.FxUtils;
import io.sitoolkit.wt.gui.pres.MessageView;
import io.sitoolkit.wt.gui.pres.TestToolbarController;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Label;
import javafx.scene.layout.HBox;
import javax.annotation.Resource;
import lombok.Generated;

public class SampleToolbarController
implements Initializable {
    @FXML
    private HBox sampleToolbar;
    @FXML
    private Label runSampleButton;
    @FXML
    private Label stopSampleButton;
    private TestToolbarController testToolbarController;
    private MessageView messageView;
    private ProjectState projectState;
    private BooleanProperty running = new SimpleBooleanProperty(false);
    @Resource
    SampleService service;

    @Override
    public void initialize(URL location, ResourceBundle resources) {
    }

    public void initialize(MessageView messageView, TestToolbarController testToolbarController, ProjectState projectState) {
        this.projectState = projectState;
        this.testToolbarController = testToolbarController;
        this.messageView = messageView;
        FxUtils.bindVisible(this.sampleToolbar, projectState.isLoaded());
        FxUtils.bindVisible(this.runSampleButton, this.running.not());
        FxUtils.bindVisible(this.stopSampleButton, this.running);
    }

    @FXML
    public void runSample() {
        this.projectState.setState(ProjectState.State.LOCKING);
        this.messageView.startMsg("\u30b5\u30f3\u30d7\u30ebWeb\u30b5\u30a4\u30c8\u3092\u8d77\u52d5\u3057\u307e\u3059\u3002");
        this.service.create(this.projectState.getBaseDirPath());
        this.service.start(8280, this.projectState.getBaseDirPath(), this.onStarted());
    }

    private SampleStartedCallback onStarted() {
        return success -> {
            if (success) {
                String sampleBaseUrl = "http://localhost:8280";
                this.messageView.addMsg("\u30b5\u30f3\u30d7\u30ebWeb\u30b5\u30a4\u30c8\u3092\u8d77\u52d5\u3057\u307e\u3057\u305f\u3002" + sampleBaseUrl + "/input.html");
                this.messageView.addMsg("\u30b5\u30f3\u30d7\u30eb\u30c6\u30b9\u30c8\u30b9\u30af\u30ea\u30d7\u30c8testscript/SampleTestScript.csv\u3092\u5de6\u306e\u30c4\u30ea\u30fc\u3067\u9078\u629e\u3057\u3066\u5b9f\u884c\u3067\u304d\u307e\u3059\u3002");
                this.testToolbarController.setBaseUrl(sampleBaseUrl);
                this.running.set(true);
            } else {
                this.messageView.addMsg("\u30b5\u30f3\u30d7\u30ebWeb\u30b5\u30a4\u30c8\u306e\u8d77\u52d5\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
                this.running.set(false);
            }
            this.projectState.reset();
        };
    }

    @FXML
    public void stopSample() {
        this.messageView.startMsg("\u30b5\u30f3\u30d7\u30ebWeb\u30b5\u30a4\u30c8\u3092\u505c\u6b62\u3057\u307e\u3059\u3002");
        this.service.stop(retCode -> {
            this.running.set(false);
            Platform.runLater(() -> this.messageView.addMsg("\u30b5\u30f3\u30d7\u30ebWeb\u30b5\u30a4\u30c8\u3092\u505c\u6b62\u3057\u307e\u3057\u305f\u3002"));
        });
    }

    public void destroy() {
        this.service.stop();
    }

    @Generated
    public BooleanProperty getRunning() {
        return this.running;
    }
}

