/*
 * Decompiled with CFR 0.152.
 */
package io.sitoolkit.wt.gui.pres;

import io.sitoolkit.wt.domain.debug.DebugListener;
import io.sitoolkit.wt.gui.app.script.ScriptService;
import io.sitoolkit.wt.gui.domain.test.DebugListenerFinder;
import io.sitoolkit.wt.gui.pres.FileOpenable;
import io.sitoolkit.wt.gui.pres.FileSaver;
import io.sitoolkit.wt.gui.pres.editor.DefaultEditorController;
import io.sitoolkit.wt.gui.pres.editor.EditorController;
import io.sitoolkit.wt.gui.pres.editor.WebViewController;
import io.sitoolkit.wt.gui.pres.editor.testscript.TestScriptEditorController;
import java.io.File;
import java.nio.file.Path;
import java.util.Optional;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.scene.Node;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.Tooltip;
import lombok.Generated;

public class EditorTabController
implements FileOpenable,
DebugListenerFinder,
FileSaver {
    private TabPane tabs;
    private BooleanProperty empty = new SimpleBooleanProperty(true);
    private ScriptService scriptService;

    public void initialize() {
        this.tabs.getSelectionModel().selectedItemProperty().addListener((observable, oldVal, newVal) -> {
            if (newVal == null) {
                this.empty.set(true);
            } else {
                this.empty.set(false);
            }
        });
    }

    @Override
    public void open(File file) {
        this.open(file.toPath());
    }

    public void open(Path file) {
        Optional<Tab> editorTab = this.findTabByFile(file);
        if (editorTab.isPresent()) {
            this.tabs.getSelectionModel().select(editorTab.get());
        } else {
            Platform.runLater(() -> {
                EditorController editorContoroller = this.getEditorController(file);
                editorContoroller.open(file);
                editorContoroller.getEditorContent().ifPresent(content -> {
                    Tab tab = new Tab();
                    tab.setUserData(editorContoroller);
                    this.setFileInfo(tab, file);
                    tab.setContent((Node)content);
                    this.tabs.getTabs().add(tab);
                    this.tabs.getSelectionModel().select(tab);
                });
            });
        }
    }

    @Override
    public void save() {
        if (this.canSave()) {
            this.getSelectedEditorController().save();
        }
    }

    public void saveAs(Path file) {
        this.getSelectedEditorController().saveAs(file);
        this.setFileInfo((Tab)this.tabs.getSelectionModel().getSelectedItem(), file);
    }

    private Optional<Tab> findTabByFile(Path file) {
        return this.tabs.getTabs().stream().filter(tab -> tab.getTooltip().getText().equals(file.toAbsolutePath().toString())).findFirst();
    }

    private EditorController getEditorController(Path file) {
        String pathStr = file.toString();
        if (pathStr.endsWith(".csv")) {
            return new TestScriptEditorController(this.scriptService);
        }
        if (pathStr.endsWith(".html")) {
            return new WebViewController();
        }
        return new DefaultEditorController();
    }

    private EditorController getSelectedEditorController() {
        return (EditorController)((Tab)this.tabs.getSelectionModel().getSelectedItem()).getUserData();
    }

    private boolean canSave() {
        return !this.tabs.getSelectionModel().isEmpty();
    }

    private void setFileInfo(Tab tab, Path file) {
        tab.setText(file.getFileName().toString());
        tab.setTooltip(new Tooltip(file.toAbsolutePath().toString()));
    }

    @Override
    public Optional<DebugListener> find(Path path) {
        return this.tabs.getTabs().stream().filter(tab -> tab.getTooltip().getText().equals(path.toAbsolutePath().toString())).filter(tab -> DebugListener.class.isInstance(tab.getUserData())).map(tab -> (DebugListener)DebugListener.class.cast(tab.getUserData())).findFirst();
    }

    @Generated
    public void setTabs(TabPane tabs) {
        this.tabs = tabs;
    }

    @Generated
    public BooleanProperty getEmpty() {
        return this.empty;
    }

    @Generated
    public void setScriptService(ScriptService scriptService) {
        this.scriptService = scriptService;
    }
}

