/*
 * Decompiled with CFR 0.152.
 */
package io.sitoolkit.wt.gui.pres;

import io.sitoolkit.wt.gui.app.diffevidence.DiffEvidenceService;
import io.sitoolkit.wt.gui.domain.project.ProjectState;
import io.sitoolkit.wt.gui.infra.fx.FxUtils;
import io.sitoolkit.wt.gui.pres.FileTreeController;
import io.sitoolkit.wt.gui.pres.MessageView;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Alert;
import javafx.scene.layout.HBox;
import javax.annotation.Resource;

public class DiffEvidenceToolbarController
implements Initializable {
    @FXML
    private HBox diffEvidenceToolbar;
    private FileTreeController fileTreeController;
    private MessageView messageView;
    private ProjectState projectState;
    @Resource
    private DiffEvidenceService diffEvidenceService;

    @Override
    public void initialize(URL location, ResourceBundle resources) {
    }

    public void initialize(MessageView messageView, FileTreeController fileTreeController, ProjectState projectState) {
        this.projectState = projectState;
        this.fileTreeController = fileTreeController;
        this.messageView = messageView;
        FxUtils.bindVisible(this.diffEvidenceToolbar, projectState.isLoaded());
    }

    @FXML
    public void maskEvidence() {
        this.messageView.startMsg("\u30b9\u30af\u30ea\u30fc\u30f3\u30b7\u30e7\u30c3\u30c8\u306b\u30de\u30b9\u30af\u51e6\u7406\u3092\u65bd\u3057\u305f\u30a8\u30d3\u30c7\u30f3\u30b9\u3092\u751f\u6210\u3057\u307e\u3059\u3002");
        boolean success = this.diffEvidenceService.genMaskEvidence(this.fileTreeController.getSelectedItem());
        this.projectState.reset();
        if (!success) {
            Alert alert = new Alert(Alert.AlertType.INFORMATION);
            alert.setTitle("");
            alert.setContentText("");
            alert.setHeaderText("\u30de\u30b9\u30af\u5bfe\u8c61\u306e\u30a8\u30d3\u30c7\u30f3\u30b9\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u30921\u3064\u9078\u629e\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
            alert.show();
        }
    }

    @FXML
    public void setBaseEvidence() {
        this.messageView.startMsg("\u57fa\u6e96\u30a8\u30d3\u30c7\u30f3\u30b9\u78ba\u5b9a\u51e6\u7406\u3092\u5b9f\u884c\u3057\u307e\u3059\u3002");
        boolean success = this.diffEvidenceService.setBaseEvidence(this.fileTreeController.getSelectedItem());
        this.projectState.reset();
        if (!success) {
            Alert alert = new Alert(Alert.AlertType.INFORMATION);
            alert.setTitle("");
            alert.setContentText("");
            alert.setHeaderText("\u57fa\u6e96\u30a8\u30d3\u30c7\u30f3\u30b9\u3068\u3057\u3066\u78ba\u5b9a\u3059\u308b\u30a8\u30d3\u30c7\u30f3\u30b9\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u30921\u3064\u9078\u629e\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
            alert.show();
        }
    }

    @FXML
    public void genDiffEvidence() {
        this.messageView.startMsg("\u6bd4\u8f03\u30a8\u30d3\u30c7\u30f3\u30b9\u3092\u751f\u6210\u3057\u307e\u3059\u3002");
        boolean success = this.diffEvidenceService.genDiffEvidence(this.fileTreeController.getRoot(), this.fileTreeController.getSelectedItems(false));
        this.projectState.reset();
        if (!success) {
            Alert alert = new Alert(Alert.AlertType.INFORMATION);
            alert.setTitle("");
            alert.setContentText("");
            alert.setHeaderText("\u6bd4\u8f03\u5bfe\u8c61\u306e\u30a8\u30d3\u30c7\u30f3\u30b9\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u30921\u3064\u3001\u307e\u305f\u306f2\u3064\u9078\u629e\u3057\u3066\u304f\u3060\u3055\u3044\u30021\u3064\u3060\u3051\u9078\u629e\u3057\u305f\u5834\u5408\u306f\u3001\u9078\u629e\u3057\u305f\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u3068\u57fa\u6e96\u30a8\u30d3\u30c7\u30f3\u30b9\u3092\u6bd4\u8f03\u3057\u307e\u3059\u3002");
            alert.show();
        }
    }
}

